package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails(
    instanceType: Optional[NonEmptyString] = Optional.Absent,
    weightedCapacity: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails = {
    import AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails
      .builder()
      .optionallyWith(
        instanceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceType)
      .optionallyWith(
        weightedCapacity.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.weightedCapacity)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails
      .wrap(buildAwsValue())
}
object AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails =
      zio.aws.securityhub.model
        .AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails(
          instanceType.map(value => value),
          weightedCapacity.map(value => value)
        )
    def instanceType: Optional[NonEmptyString]
    def weightedCapacity: Optional[NonEmptyString]
    def getInstanceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getWeightedCapacity: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("weightedCapacity", weightedCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails
  ) extends zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.ReadOnly {
    override val instanceType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val weightedCapacity: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weightedCapacity())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails
  ): zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.ReadOnly =
    new Wrapper(impl)
}
