package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsApiGatewayRestApiDetails(
    id: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    createdDate: Optional[NonEmptyString] = Optional.Absent,
    version: Optional[NonEmptyString] = Optional.Absent,
    binaryMediaTypes: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    minimumCompressionSize: Optional[Integer] = Optional.Absent,
    apiKeySource: Optional[NonEmptyString] = Optional.Absent,
    endpointConfiguration: Optional[
      zio.aws.securityhub.model.AwsApiGatewayEndpointConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiGatewayRestApiDetails = {
    import AwsApiGatewayRestApiDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayRestApiDetails
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        createdDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdDate)
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        binaryMediaTypes.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.binaryMediaTypes)
      .optionallyWith(
        minimumCompressionSize.map(value => value: java.lang.Integer)
      )(_.minimumCompressionSize)
      .optionallyWith(
        apiKeySource.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.apiKeySource)
      .optionallyWith(
        endpointConfiguration.map(value => value.buildAwsValue())
      )(_.endpointConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsApiGatewayRestApiDetails.ReadOnly =
    zio.aws.securityhub.model.AwsApiGatewayRestApiDetails.wrap(buildAwsValue())
}
object AwsApiGatewayRestApiDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayRestApiDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiGatewayRestApiDetails =
      zio.aws.securityhub.model.AwsApiGatewayRestApiDetails(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        createdDate.map(value => value),
        version.map(value => value),
        binaryMediaTypes.map(value => value),
        minimumCompressionSize.map(value => value),
        apiKeySource.map(value => value),
        endpointConfiguration.map(value => value.asEditable)
      )
    def id: Optional[NonEmptyString]
    def name: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def createdDate: Optional[NonEmptyString]
    def version: Optional[NonEmptyString]
    def binaryMediaTypes: Optional[List[NonEmptyString]]
    def minimumCompressionSize: Optional[Integer]
    def apiKeySource: Optional[NonEmptyString]
    def endpointConfiguration: Optional[
      zio.aws.securityhub.model.AwsApiGatewayEndpointConfiguration.ReadOnly
    ]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
    def getBinaryMediaTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("binaryMediaTypes", binaryMediaTypes)
    def getMinimumCompressionSize: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("minimumCompressionSize", minimumCompressionSize)
    def getApiKeySource: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("apiKeySource", apiKeySource)
    def getEndpointConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayEndpointConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("endpointConfiguration", endpointConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayRestApiDetails
  ) extends zio.aws.securityhub.model.AwsApiGatewayRestApiDetails.ReadOnly {
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val createdDate: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val version: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val binaryMediaTypes: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.binaryMediaTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val minimumCompressionSize: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimumCompressionSize())
        .map(value => value: Integer)
    override val apiKeySource: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.apiKeySource())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpointConfiguration: Optional[
      zio.aws.securityhub.model.AwsApiGatewayEndpointConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsApiGatewayEndpointConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayRestApiDetails
  ): zio.aws.securityhub.model.AwsApiGatewayRestApiDetails.ReadOnly =
    new Wrapper(impl)
}
