package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait WorkflowState {
  def unwrap: software.amazon.awssdk.services.securityhub.model.WorkflowState
}
object WorkflowState {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.WorkflowState
  ): zio.aws.securityhub.model.WorkflowState = value match {
    case software.amazon.awssdk.services.securityhub.model.WorkflowState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.WorkflowState.NEW =>
      val r = NEW
      r
    case software.amazon.awssdk.services.securityhub.model.WorkflowState.ASSIGNED =>
      val r = ASSIGNED
      r
    case software.amazon.awssdk.services.securityhub.model.WorkflowState.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.securityhub.model.WorkflowState.DEFERRED =>
      val r = DEFERRED
      r
    case software.amazon.awssdk.services.securityhub.model.WorkflowState.RESOLVED =>
      val r = RESOLVED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.WorkflowState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.WorkflowState =
      software.amazon.awssdk.services.securityhub.model.WorkflowState.UNKNOWN_TO_SDK_VERSION
  }
  case object NEW extends zio.aws.securityhub.model.WorkflowState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.WorkflowState =
      software.amazon.awssdk.services.securityhub.model.WorkflowState.NEW
  }
  case object ASSIGNED extends zio.aws.securityhub.model.WorkflowState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.WorkflowState =
      software.amazon.awssdk.services.securityhub.model.WorkflowState.ASSIGNED
  }
  case object IN_PROGRESS extends zio.aws.securityhub.model.WorkflowState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.WorkflowState =
      software.amazon.awssdk.services.securityhub.model.WorkflowState.IN_PROGRESS
  }
  case object DEFERRED extends zio.aws.securityhub.model.WorkflowState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.WorkflowState =
      software.amazon.awssdk.services.securityhub.model.WorkflowState.DEFERRED
  }
  case object RESOLVED extends zio.aws.securityhub.model.WorkflowState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.WorkflowState =
      software.amazon.awssdk.services.securityhub.model.WorkflowState.RESOLVED
  }
}
