package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SortCriterion(
    field: Optional[NonEmptyString] = Optional.Absent,
    sortOrder: Optional[zio.aws.securityhub.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.SortCriterion = {
    import SortCriterion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.SortCriterion
      .builder()
      .optionallyWith(
        field.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.field)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.SortCriterion.ReadOnly =
    zio.aws.securityhub.model.SortCriterion.wrap(buildAwsValue())
}
object SortCriterion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.SortCriterion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.SortCriterion =
      zio.aws.securityhub.model
        .SortCriterion(field.map(value => value), sortOrder.map(value => value))
    def field: Optional[NonEmptyString]
    def sortOrder: Optional[zio.aws.securityhub.model.SortOrder]
    def getField: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("field", field)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.securityhub.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.SortCriterion
  ) extends zio.aws.securityhub.model.SortCriterion.ReadOnly {
    override val field: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.field())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sortOrder: Optional[zio.aws.securityhub.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.securityhub.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.SortCriterion
  ): zio.aws.securityhub.model.SortCriterion.ReadOnly = new Wrapper(impl)
}
