package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InviteMembersResponse(
    unprocessedAccounts: Optional[Iterable[zio.aws.securityhub.model.Result]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.InviteMembersResponse = {
    import InviteMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.InviteMembersResponse
      .builder()
      .optionallyWith(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAccounts)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.InviteMembersResponse.ReadOnly =
    zio.aws.securityhub.model.InviteMembersResponse.wrap(buildAwsValue())
}
object InviteMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.InviteMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.InviteMembersResponse =
      zio.aws.securityhub.model.InviteMembersResponse(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def unprocessedAccounts
        : Optional[List[zio.aws.securityhub.model.Result.ReadOnly]]
    def getUnprocessedAccounts
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Result.ReadOnly]] =
      AwsError.unwrapOptionField("unprocessedAccounts", unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.InviteMembersResponse
  ) extends zio.aws.securityhub.model.InviteMembersResponse.ReadOnly {
    override val unprocessedAccounts
        : Optional[List[zio.aws.securityhub.model.Result.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unprocessedAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Result.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.InviteMembersResponse
  ): zio.aws.securityhub.model.InviteMembersResponse.ReadOnly = new Wrapper(
    impl
  )
}
