package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsSsmPatch(
    complianceSummary: Optional[
      zio.aws.securityhub.model.AwsSsmComplianceSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSsmPatch = {
    import AwsSsmPatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSsmPatch
      .builder()
      .optionallyWith(complianceSummary.map(value => value.buildAwsValue()))(
        _.complianceSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsSsmPatch.ReadOnly =
    zio.aws.securityhub.model.AwsSsmPatch.wrap(buildAwsValue())
}
object AwsSsmPatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSsmPatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsSsmPatch =
      zio.aws.securityhub.model
        .AwsSsmPatch(complianceSummary.map(value => value.asEditable))
    def complianceSummary
        : Optional[zio.aws.securityhub.model.AwsSsmComplianceSummary.ReadOnly]
    def getComplianceSummary: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsSsmComplianceSummary.ReadOnly
    ] = AwsError.unwrapOptionField("complianceSummary", complianceSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSsmPatch
  ) extends zio.aws.securityhub.model.AwsSsmPatch.ReadOnly {
    override val complianceSummary
        : Optional[zio.aws.securityhub.model.AwsSsmComplianceSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceSummary())
        .map(value =>
          zio.aws.securityhub.model.AwsSsmComplianceSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSsmPatch
  ): zio.aws.securityhub.model.AwsSsmPatch.ReadOnly = new Wrapper(impl)
}
