package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AwsSecurityFindingIdentifier(
    id: NonEmptyString,
    productArn: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingIdentifier = {
    import AwsSecurityFindingIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingIdentifier
      .builder()
      .id(NonEmptyString.unwrap(id): java.lang.String)
      .productArn(NonEmptyString.unwrap(productArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly =
    zio.aws.securityhub.model.AwsSecurityFindingIdentifier.wrap(buildAwsValue())
}
object AwsSecurityFindingIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsSecurityFindingIdentifier =
      zio.aws.securityhub.model.AwsSecurityFindingIdentifier(id, productArn)
    def id: NonEmptyString
    def productArn: NonEmptyString
    def getId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(id)
    def getProductArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(productArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingIdentifier
  ) extends zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly {
    override val id: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.id())
    override val productArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.productArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingIdentifier
  ): zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly =
    new Wrapper(impl)
}
