package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails(
    date: Optional[NonEmptyString] = Optional.Absent,
    days: Optional[Integer] = Optional.Absent,
    storageClass: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails = {
    import AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails
      .builder()
      .optionallyWith(
        date.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.date)
      .optionallyWith(days.map(value => value: java.lang.Integer))(_.days)
      .optionallyWith(
        storageClass.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.storageClass)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails
      .wrap(buildAwsValue())
}
object AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails =
      zio.aws.securityhub.model
        .AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails(
          date.map(value => value),
          days.map(value => value),
          storageClass.map(value => value)
        )
    def date: Optional[NonEmptyString]
    def days: Optional[Integer]
    def storageClass: Optional[NonEmptyString]
    def getDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("date", date)
    def getDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("days", days)
    def getStorageClass: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("storageClass", storageClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.ReadOnly {
    override val date: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.date())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val days: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.days())
      .map(value => value: Integer)
    override val storageClass: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.storageClass())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails
  ): zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.ReadOnly =
    new Wrapper(impl)
}
