package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsDbClusterDetails(
    allocatedStorage: Optional[Integer] = Optional.Absent,
    availabilityZones: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    backupRetentionPeriod: Optional[Integer] = Optional.Absent,
    databaseName: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent,
    endpoint: Optional[NonEmptyString] = Optional.Absent,
    readerEndpoint: Optional[NonEmptyString] = Optional.Absent,
    customEndpoints: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    multiAz: Optional[Boolean] = Optional.Absent,
    engine: Optional[NonEmptyString] = Optional.Absent,
    engineVersion: Optional[NonEmptyString] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    masterUsername: Optional[NonEmptyString] = Optional.Absent,
    preferredBackupWindow: Optional[NonEmptyString] = Optional.Absent,
    preferredMaintenanceWindow: Optional[NonEmptyString] = Optional.Absent,
    readReplicaIdentifiers: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    vpcSecurityGroups: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup]
    ] = Optional.Absent,
    hostedZoneId: Optional[NonEmptyString] = Optional.Absent,
    storageEncrypted: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    dbClusterResourceId: Optional[NonEmptyString] = Optional.Absent,
    associatedRoles: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole]
    ] = Optional.Absent,
    clusterCreateTime: Optional[NonEmptyString] = Optional.Absent,
    enabledCloudWatchLogsExports: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    engineMode: Optional[NonEmptyString] = Optional.Absent,
    deletionProtection: Optional[Boolean] = Optional.Absent,
    httpEndpointEnabled: Optional[Boolean] = Optional.Absent,
    activityStreamStatus: Optional[NonEmptyString] = Optional.Absent,
    copyTagsToSnapshot: Optional[Boolean] = Optional.Absent,
    crossAccountClone: Optional[Boolean] = Optional.Absent,
    domainMemberships: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbDomainMembership]
    ] = Optional.Absent,
    dbClusterParameterGroup: Optional[NonEmptyString] = Optional.Absent,
    dbSubnetGroup: Optional[NonEmptyString] = Optional.Absent,
    dbClusterOptionGroupMemberships: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership]
    ] = Optional.Absent,
    dbClusterIdentifier: Optional[NonEmptyString] = Optional.Absent,
    dbClusterMembers: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbClusterMember]
    ] = Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterDetails = {
    import AwsRdsDbClusterDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterDetails
      .builder()
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        backupRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.backupRetentionPeriod)
      .optionallyWith(
        databaseName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.databaseName)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        endpoint.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.endpoint)
      .optionallyWith(
        readerEndpoint.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.readerEndpoint)
      .optionallyWith(
        customEndpoints.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.customEndpoints)
      .optionallyWith(multiAz.map(value => value: java.lang.Boolean))(_.multiAz)
      .optionallyWith(
        engine.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.engine)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        masterUsername.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUsername)
      .optionallyWith(
        preferredBackupWindow.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        readReplicaIdentifiers.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaIdentifiers)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(
        hostedZoneId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.hostedZoneId)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        dbClusterResourceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbClusterResourceId)
      .optionallyWith(
        associatedRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedRoles)
      .optionallyWith(
        clusterCreateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterCreateTime)
      .optionallyWith(
        enabledCloudWatchLogsExports.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.enabledCloudWatchLogsExports)
      .optionallyWith(
        engineMode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.engineMode)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        httpEndpointEnabled.map(value => value: java.lang.Boolean)
      )(_.httpEndpointEnabled)
      .optionallyWith(
        activityStreamStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.activityStreamStatus)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(crossAccountClone.map(value => value: java.lang.Boolean))(
        _.crossAccountClone
      )
      .optionallyWith(
        domainMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainMemberships)
      .optionallyWith(
        dbClusterParameterGroup.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbClusterParameterGroup)
      .optionallyWith(
        dbSubnetGroup.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbSubnetGroup)
      .optionallyWith(
        dbClusterOptionGroupMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterOptionGroupMemberships)
      .optionallyWith(
        dbClusterIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbClusterIdentifier)
      .optionallyWith(
        dbClusterMembers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterMembers)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRdsDbClusterDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbClusterDetails.wrap(buildAwsValue())
}
object AwsRdsDbClusterDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbClusterDetails =
      zio.aws.securityhub.model.AwsRdsDbClusterDetails(
        allocatedStorage.map(value => value),
        availabilityZones.map(value => value),
        backupRetentionPeriod.map(value => value),
        databaseName.map(value => value),
        status.map(value => value),
        endpoint.map(value => value),
        readerEndpoint.map(value => value),
        customEndpoints.map(value => value),
        multiAz.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        port.map(value => value),
        masterUsername.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        readReplicaIdentifiers.map(value => value),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hostedZoneId.map(value => value),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        dbClusterResourceId.map(value => value),
        associatedRoles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterCreateTime.map(value => value),
        enabledCloudWatchLogsExports.map(value => value),
        engineMode.map(value => value),
        deletionProtection.map(value => value),
        httpEndpointEnabled.map(value => value),
        activityStreamStatus.map(value => value),
        copyTagsToSnapshot.map(value => value),
        crossAccountClone.map(value => value),
        domainMemberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbClusterParameterGroup.map(value => value),
        dbSubnetGroup.map(value => value),
        dbClusterOptionGroupMemberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbClusterIdentifier.map(value => value),
        dbClusterMembers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        iamDatabaseAuthenticationEnabled.map(value => value)
      )
    def allocatedStorage: Optional[Integer]
    def availabilityZones: Optional[List[NonEmptyString]]
    def backupRetentionPeriod: Optional[Integer]
    def databaseName: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def endpoint: Optional[NonEmptyString]
    def readerEndpoint: Optional[NonEmptyString]
    def customEndpoints: Optional[List[NonEmptyString]]
    def multiAz: Optional[Boolean]
    def engine: Optional[NonEmptyString]
    def engineVersion: Optional[NonEmptyString]
    def port: Optional[Integer]
    def masterUsername: Optional[NonEmptyString]
    def preferredBackupWindow: Optional[NonEmptyString]
    def preferredMaintenanceWindow: Optional[NonEmptyString]
    def readReplicaIdentifiers: Optional[List[NonEmptyString]]
    def vpcSecurityGroups: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.ReadOnly]
    ]
    def hostedZoneId: Optional[NonEmptyString]
    def storageEncrypted: Optional[Boolean]
    def kmsKeyId: Optional[NonEmptyString]
    def dbClusterResourceId: Optional[NonEmptyString]
    def associatedRoles: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole.ReadOnly]
    ]
    def clusterCreateTime: Optional[NonEmptyString]
    def enabledCloudWatchLogsExports: Optional[List[NonEmptyString]]
    def engineMode: Optional[NonEmptyString]
    def deletionProtection: Optional[Boolean]
    def httpEndpointEnabled: Optional[Boolean]
    def activityStreamStatus: Optional[NonEmptyString]
    def copyTagsToSnapshot: Optional[Boolean]
    def crossAccountClone: Optional[Boolean]
    def domainMemberships: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbDomainMembership.ReadOnly]
    ]
    def dbClusterParameterGroup: Optional[NonEmptyString]
    def dbSubnetGroup: Optional[NonEmptyString]
    def dbClusterOptionGroupMemberships: Optional[List[
      zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership.ReadOnly
    ]]
    def dbClusterIdentifier: Optional[NonEmptyString]
    def dbClusterMembers: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbClusterMember.ReadOnly]
    ]
    def iamDatabaseAuthenticationEnabled: Optional[Boolean]
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getAvailabilityZones: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDatabaseName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getReaderEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("readerEndpoint", readerEndpoint)
    def getCustomEndpoints: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("customEndpoints", customEndpoints)
    def getMultiAz: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAz", multiAz)
    def getEngine: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getPreferredBackupWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getReadReplicaIdentifiers: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "readReplicaIdentifiers",
        readReplicaIdentifiers
      )
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getHostedZoneId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbClusterResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbClusterResourceId", dbClusterResourceId)
    def getAssociatedRoles: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole.ReadOnly
    ]] = AwsError.unwrapOptionField("associatedRoles", associatedRoles)
    def getClusterCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getEnabledCloudWatchLogsExports
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "enabledCloudWatchLogsExports",
      enabledCloudWatchLogsExports
    )
    def getEngineMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineMode", engineMode)
    def getDeletionProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getHttpEndpointEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("httpEndpointEnabled", httpEndpointEnabled)
    def getActivityStreamStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("activityStreamStatus", activityStreamStatus)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getCrossAccountClone: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crossAccountClone", crossAccountClone)
    def getDomainMemberships: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbDomainMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("domainMemberships", domainMemberships)
    def getDbClusterParameterGroup: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroup",
        dbClusterParameterGroup
      )
    def getDbSubnetGroup: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
    def getDbClusterOptionGroupMemberships: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbClusterOptionGroupMemberships",
      dbClusterOptionGroupMemberships
    )
    def getDbClusterIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDbClusterMembers: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbClusterMember.ReadOnly
    ]] = AwsError.unwrapOptionField("dbClusterMembers", dbClusterMembers)
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterDetails
  ) extends zio.aws.securityhub.model.AwsRdsDbClusterDetails.ReadOnly {
    override val allocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.allocatedStorage())
      .map(value => value: Integer)
    override val availabilityZones: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val backupRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: Integer)
    override val databaseName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpoint: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val readerEndpoint: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readerEndpoint())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val customEndpoints: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val multiAz: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAz())
      .map(value => value: Boolean)
    override val engine: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val engineVersion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val masterUsername: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUsername())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val preferredBackupWindow: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredBackupWindow())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val preferredMaintenanceWindow: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val readReplicaIdentifiers: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readReplicaIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val vpcSecurityGroups: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.wrap(item)
        }.toList
      )
    override val hostedZoneId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.hostedZoneId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val storageEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.storageEncrypted())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbClusterResourceId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterResourceId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val associatedRoles: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associatedRoles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole.wrap(item)
        }.toList
      )
    override val clusterCreateTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterCreateTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val enabledCloudWatchLogsExports: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enabledCloudWatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val engineMode: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engineMode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deletionProtection: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionProtection())
      .map(value => value: Boolean)
    override val httpEndpointEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.httpEndpointEnabled())
      .map(value => value: Boolean)
    override val activityStreamStatus: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityStreamStatus())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val copyTagsToSnapshot: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToSnapshot())
      .map(value => value: Boolean)
    override val crossAccountClone: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crossAccountClone())
      .map(value => value: Boolean)
    override val domainMemberships: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbDomainMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbDomainMembership.wrap(item)
        }.toList
      )
    override val dbClusterParameterGroup: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroup())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val dbSubnetGroup: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroup())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbClusterOptionGroupMemberships: Optional[List[
      zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterOptionGroupMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership
            .wrap(item)
        }.toList
      )
    override val dbClusterIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val dbClusterMembers: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbClusterMember.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterMembers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbClusterMember.wrap(item)
        }.toList
      )
    override val iamDatabaseAuthenticationEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterDetails
  ): zio.aws.securityhub.model.AwsRdsDbClusterDetails.ReadOnly = new Wrapper(
    impl
  )
}
