package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails(
    automatedUpdateDate: Optional[NonEmptyString] = Optional.Absent,
    cancellable: Optional[Boolean] = Optional.Absent,
    currentVersion: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    newVersion: Optional[NonEmptyString] = Optional.Absent,
    updateAvailable: Optional[Boolean] = Optional.Absent,
    updateStatus: Optional[NonEmptyString] = Optional.Absent,
    optionalDeployment: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails = {
    import AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails
      .builder()
      .optionallyWith(
        automatedUpdateDate.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.automatedUpdateDate)
      .optionallyWith(cancellable.map(value => value: java.lang.Boolean))(
        _.cancellable
      )
      .optionallyWith(
        currentVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.currentVersion)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        newVersion.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.newVersion)
      .optionallyWith(updateAvailable.map(value => value: java.lang.Boolean))(
        _.updateAvailable
      )
      .optionallyWith(
        updateStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.updateStatus)
      .optionallyWith(
        optionalDeployment.map(value => value: java.lang.Boolean)
      )(_.optionalDeployment)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails
      .wrap(buildAwsValue())
}
object AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails =
      zio.aws.securityhub.model
        .AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails(
          automatedUpdateDate.map(value => value),
          cancellable.map(value => value),
          currentVersion.map(value => value),
          description.map(value => value),
          newVersion.map(value => value),
          updateAvailable.map(value => value),
          updateStatus.map(value => value),
          optionalDeployment.map(value => value)
        )
    def automatedUpdateDate: Optional[NonEmptyString]
    def cancellable: Optional[Boolean]
    def currentVersion: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def newVersion: Optional[NonEmptyString]
    def updateAvailable: Optional[Boolean]
    def updateStatus: Optional[NonEmptyString]
    def optionalDeployment: Optional[Boolean]
    def getAutomatedUpdateDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("automatedUpdateDate", automatedUpdateDate)
    def getCancellable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cancellable", cancellable)
    def getCurrentVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getNewVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("newVersion", newVersion)
    def getUpdateAvailable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("updateAvailable", updateAvailable)
    def getUpdateStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("updateStatus", updateStatus)
    def getOptionalDeployment: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("optionalDeployment", optionalDeployment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails
  ) extends zio.aws.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.ReadOnly {
    override val automatedUpdateDate: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automatedUpdateDate())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val cancellable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cancellable())
      .map(value => value: Boolean)
    override val currentVersion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentVersion())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val newVersion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.newVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val updateAvailable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.updateAvailable())
      .map(value => value: Boolean)
    override val updateStatus: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.updateStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val optionalDeployment: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.optionalDeployment())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails
  ): zio.aws.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
