package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElasticsearchDomainDetails(
    accessPolicies: Optional[NonEmptyString] = Optional.Absent,
    domainEndpointOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions
    ] = Optional.Absent,
    domainId: Optional[NonEmptyString] = Optional.Absent,
    domainName: Optional[NonEmptyString] = Optional.Absent,
    endpoint: Optional[NonEmptyString] = Optional.Absent,
    endpoints: Optional[Map[NonEmptyString, NonEmptyString]] = Optional.Absent,
    elasticsearchVersion: Optional[NonEmptyString] = Optional.Absent,
    elasticsearchClusterConfig: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails
    ] = Optional.Absent,
    encryptionAtRestOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions
    ] = Optional.Absent,
    logPublishingOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions
    ] = Optional.Absent,
    nodeToNodeEncryptionOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions
    ] = Optional.Absent,
    serviceSoftwareOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions
    ] = Optional.Absent,
    vpcOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDetails = {
    import AwsElasticsearchDomainDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDetails
      .builder()
      .optionallyWith(
        accessPolicies.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.accessPolicies)
      .optionallyWith(
        domainEndpointOptions.map(value => value.buildAwsValue())
      )(_.domainEndpointOptions)
      .optionallyWith(
        domainId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        domainName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        endpoint.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.endpoint)
      .optionallyWith(
        endpoints.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.endpoints)
      .optionallyWith(
        elasticsearchVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.elasticsearchVersion)
      .optionallyWith(
        elasticsearchClusterConfig.map(value => value.buildAwsValue())
      )(_.elasticsearchClusterConfig)
      .optionallyWith(
        encryptionAtRestOptions.map(value => value.buildAwsValue())
      )(_.encryptionAtRestOptions)
      .optionallyWith(logPublishingOptions.map(value => value.buildAwsValue()))(
        _.logPublishingOptions
      )
      .optionallyWith(
        nodeToNodeEncryptionOptions.map(value => value.buildAwsValue())
      )(_.nodeToNodeEncryptionOptions)
      .optionallyWith(
        serviceSoftwareOptions.map(value => value.buildAwsValue())
      )(_.serviceSoftwareOptions)
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticsearchDomainDetails.ReadOnly =
    zio.aws.securityhub.model.AwsElasticsearchDomainDetails
      .wrap(buildAwsValue())
}
object AwsElasticsearchDomainDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElasticsearchDomainDetails =
      zio.aws.securityhub.model.AwsElasticsearchDomainDetails(
        accessPolicies.map(value => value),
        domainEndpointOptions.map(value => value.asEditable),
        domainId.map(value => value),
        domainName.map(value => value),
        endpoint.map(value => value),
        endpoints.map(value => value),
        elasticsearchVersion.map(value => value),
        elasticsearchClusterConfig.map(value => value.asEditable),
        encryptionAtRestOptions.map(value => value.asEditable),
        logPublishingOptions.map(value => value.asEditable),
        nodeToNodeEncryptionOptions.map(value => value.asEditable),
        serviceSoftwareOptions.map(value => value.asEditable),
        vpcOptions.map(value => value.asEditable)
      )
    def accessPolicies: Optional[NonEmptyString]
    def domainEndpointOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions.ReadOnly
    ]
    def domainId: Optional[NonEmptyString]
    def domainName: Optional[NonEmptyString]
    def endpoint: Optional[NonEmptyString]
    def endpoints: Optional[Map[NonEmptyString, NonEmptyString]]
    def elasticsearchVersion: Optional[NonEmptyString]
    def elasticsearchClusterConfig: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails.ReadOnly
    ]
    def encryptionAtRestOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions.ReadOnly
    ]
    def logPublishingOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions.ReadOnly
    ]
    def nodeToNodeEncryptionOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions.ReadOnly
    ]
    def serviceSoftwareOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions.ReadOnly
    ]
    def vpcOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions.ReadOnly
    ]
    def getAccessPolicies: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accessPolicies", accessPolicies)
    def getDomainEndpointOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("domainEndpointOptions", domainEndpointOptions)
    def getDomainId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getDomainName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getEndpoints: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("endpoints", endpoints)
    def getElasticsearchVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("elasticsearchVersion", elasticsearchVersion)
    def getElasticsearchClusterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "elasticsearchClusterConfig",
      elasticsearchClusterConfig
    )
    def getEncryptionAtRestOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionAtRestOptions",
      encryptionAtRestOptions
    )
    def getLogPublishingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions.ReadOnly
    ] = AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
    def getNodeToNodeEncryptionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nodeToNodeEncryptionOptions",
      nodeToNodeEncryptionOptions
    )
    def getServiceSoftwareOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSoftwareOptions",
      serviceSoftwareOptions
    )
    def getVpcOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions.ReadOnly
    ] = AwsError.unwrapOptionField("vpcOptions", vpcOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDetails
  ) extends zio.aws.securityhub.model.AwsElasticsearchDomainDetails.ReadOnly {
    override val accessPolicies: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessPolicies())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val domainEndpointOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainEndpointOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions
          .wrap(value)
      )
    override val domainId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.domainId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val domainName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpoint: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpoints: Optional[Map[NonEmptyString, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoints())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.securityhub.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val elasticsearchVersion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticsearchVersion())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val elasticsearchClusterConfig: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticsearchClusterConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails
          .wrap(value)
      )
    override val encryptionAtRestOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionAtRestOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions
          .wrap(value)
      )
    override val logPublishingOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logPublishingOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions
          .wrap(value)
      )
    override val nodeToNodeEncryptionOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeToNodeEncryptionOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions
          .wrap(value)
      )
    override val serviceSoftwareOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceSoftwareOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions
          .wrap(value)
      )
    override val vpcOptions: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDetails
  ): zio.aws.securityhub.model.AwsElasticsearchDomainDetails.ReadOnly =
    new Wrapper(impl)
}
