package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsServiceLoadBalancersDetails(
    containerName: Optional[NonEmptyString] = Optional.Absent,
    containerPort: Optional[Integer] = Optional.Absent,
    loadBalancerName: Optional[NonEmptyString] = Optional.Absent,
    targetGroupArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsServiceLoadBalancersDetails = {
    import AwsEcsServiceLoadBalancersDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceLoadBalancersDetails
      .builder()
      .optionallyWith(
        containerName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.containerName)
      .optionallyWith(containerPort.map(value => value: java.lang.Integer))(
        _.containerPort
      )
      .optionallyWith(
        loadBalancerName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.loadBalancerName)
      .optionallyWith(
        targetGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.targetGroupArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails
      .wrap(buildAwsValue())
}
object AwsEcsServiceLoadBalancersDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceLoadBalancersDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails =
      zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails(
        containerName.map(value => value),
        containerPort.map(value => value),
        loadBalancerName.map(value => value),
        targetGroupArn.map(value => value)
      )
    def containerName: Optional[NonEmptyString]
    def containerPort: Optional[Integer]
    def loadBalancerName: Optional[NonEmptyString]
    def targetGroupArn: Optional[NonEmptyString]
    def getContainerName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getContainerPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("containerPort", containerPort)
    def getLoadBalancerName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getTargetGroupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("targetGroupArn", targetGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceLoadBalancersDetails
  ) extends zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails.ReadOnly {
    override val containerName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.containerName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val containerPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.containerPort())
      .map(value => value: Integer)
    override val loadBalancerName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val targetGroupArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetGroupArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceLoadBalancersDetails
  ): zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails.ReadOnly =
    new Wrapper(impl)
}
