package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsServiceDetails(
    capacityProviderStrategy: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails
    ]] = Optional.Absent,
    cluster: Optional[NonEmptyString] = Optional.Absent,
    deploymentConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails
    ] = Optional.Absent,
    deploymentController: Optional[
      zio.aws.securityhub.model.AwsEcsServiceDeploymentControllerDetails
    ] = Optional.Absent,
    desiredCount: Optional[Integer] = Optional.Absent,
    enableEcsManagedTags: Optional[Boolean] = Optional.Absent,
    enableExecuteCommand: Optional[Boolean] = Optional.Absent,
    healthCheckGracePeriodSeconds: Optional[Integer] = Optional.Absent,
    launchType: Optional[NonEmptyString] = Optional.Absent,
    loadBalancers: Optional[
      Iterable[zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails]
    ] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    networkConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails
    ] = Optional.Absent,
    placementConstraints: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsServicePlacementConstraintsDetails
    ]] = Optional.Absent,
    placementStrategies: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails
    ]] = Optional.Absent,
    platformVersion: Optional[NonEmptyString] = Optional.Absent,
    propagateTags: Optional[NonEmptyString] = Optional.Absent,
    role: Optional[NonEmptyString] = Optional.Absent,
    schedulingStrategy: Optional[NonEmptyString] = Optional.Absent,
    serviceArn: Optional[NonEmptyString] = Optional.Absent,
    serviceName: Optional[NonEmptyString] = Optional.Absent,
    serviceRegistries: Optional[
      Iterable[zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails]
    ] = Optional.Absent,
    taskDefinition: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDetails = {
    import AwsEcsServiceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDetails
      .builder()
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(
        cluster.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cluster)
      .optionallyWith(
        deploymentConfiguration.map(value => value.buildAwsValue())
      )(_.deploymentConfiguration)
      .optionallyWith(deploymentController.map(value => value.buildAwsValue()))(
        _.deploymentController
      )
      .optionallyWith(desiredCount.map(value => value: java.lang.Integer))(
        _.desiredCount
      )
      .optionallyWith(
        enableEcsManagedTags.map(value => value: java.lang.Boolean)
      )(_.enableEcsManagedTags)
      .optionallyWith(
        enableExecuteCommand.map(value => value: java.lang.Boolean)
      )(_.enableExecuteCommand)
      .optionallyWith(
        healthCheckGracePeriodSeconds.map(value => value: java.lang.Integer)
      )(_.healthCheckGracePeriodSeconds)
      .optionallyWith(
        launchType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.launchType)
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(
        placementStrategies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementStrategies)
      .optionallyWith(
        platformVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.platformVersion)
      .optionallyWith(
        propagateTags.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.propagateTags)
      .optionallyWith(
        role.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.role)
      .optionallyWith(
        schedulingStrategy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.schedulingStrategy)
      .optionallyWith(
        serviceArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceArn)
      .optionallyWith(
        serviceName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        serviceRegistries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceRegistries)
      .optionallyWith(
        taskDefinition.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.taskDefinition)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEcsServiceDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsServiceDetails.wrap(buildAwsValue())
}
object AwsEcsServiceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEcsServiceDetails =
      zio.aws.securityhub.model.AwsEcsServiceDetails(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cluster.map(value => value),
        deploymentConfiguration.map(value => value.asEditable),
        deploymentController.map(value => value.asEditable),
        desiredCount.map(value => value),
        enableEcsManagedTags.map(value => value),
        enableExecuteCommand.map(value => value),
        healthCheckGracePeriodSeconds.map(value => value),
        launchType.map(value => value),
        loadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        networkConfiguration.map(value => value.asEditable),
        placementConstraints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placementStrategies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformVersion.map(value => value),
        propagateTags.map(value => value),
        role.map(value => value),
        schedulingStrategy.map(value => value),
        serviceArn.map(value => value),
        serviceName.map(value => value),
        serviceRegistries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskDefinition.map(value => value)
      )
    def capacityProviderStrategy: Optional[List[
      zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails.ReadOnly
    ]]
    def cluster: Optional[NonEmptyString]
    def deploymentConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails.ReadOnly
    ]
    def deploymentController: Optional[
      zio.aws.securityhub.model.AwsEcsServiceDeploymentControllerDetails.ReadOnly
    ]
    def desiredCount: Optional[Integer]
    def enableEcsManagedTags: Optional[Boolean]
    def enableExecuteCommand: Optional[Boolean]
    def healthCheckGracePeriodSeconds: Optional[Integer]
    def launchType: Optional[NonEmptyString]
    def loadBalancers: Optional[
      List[zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails.ReadOnly]
    ]
    def name: Optional[NonEmptyString]
    def networkConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails.ReadOnly
    ]
    def placementConstraints: Optional[List[
      zio.aws.securityhub.model.AwsEcsServicePlacementConstraintsDetails.ReadOnly
    ]]
    def placementStrategies: Optional[List[
      zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails.ReadOnly
    ]]
    def platformVersion: Optional[NonEmptyString]
    def propagateTags: Optional[NonEmptyString]
    def role: Optional[NonEmptyString]
    def schedulingStrategy: Optional[NonEmptyString]
    def serviceArn: Optional[NonEmptyString]
    def serviceName: Optional[NonEmptyString]
    def serviceRegistries: Optional[List[
      zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails.ReadOnly
    ]]
    def taskDefinition: Optional[NonEmptyString]
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getCluster: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getDeploymentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deploymentConfiguration",
      deploymentConfiguration
    )
    def getDeploymentController: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsServiceDeploymentControllerDetails.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentController", deploymentController)
    def getDesiredCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("desiredCount", desiredCount)
    def getEnableEcsManagedTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableEcsManagedTags", enableEcsManagedTags)
    def getEnableExecuteCommand: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
    def getHealthCheckGracePeriodSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "healthCheckGracePeriodSeconds",
        healthCheckGracePeriodSeconds
      )
    def getLaunchType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getLoadBalancers: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getNetworkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsServicePlacementConstraintsDetails.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getPlacementStrategies: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("placementStrategies", placementStrategies)
    def getPlatformVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getPropagateTags: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("role", role)
    def getSchedulingStrategy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("schedulingStrategy", schedulingStrategy)
    def getServiceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceArn", serviceArn)
    def getServiceName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceRegistries: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceRegistries", serviceRegistries)
    def getTaskDefinition: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("taskDefinition", taskDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDetails
  ) extends zio.aws.securityhub.model.AwsEcsServiceDetails.ReadOnly {
    override val capacityProviderStrategy: Optional[List[
      zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails
            .wrap(item)
        }.toList
      )
    override val cluster: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deploymentConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails
          .wrap(value)
      )
    override val deploymentController: Optional[
      zio.aws.securityhub.model.AwsEcsServiceDeploymentControllerDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentController())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsServiceDeploymentControllerDetails
          .wrap(value)
      )
    override val desiredCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredCount())
      .map(value => value: Integer)
    override val enableEcsManagedTags: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableEcsManagedTags())
      .map(value => value: Boolean)
    override val enableExecuteCommand: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableExecuteCommand())
      .map(value => value: Boolean)
    override val healthCheckGracePeriodSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthCheckGracePeriodSeconds())
        .map(value => value: Integer)
    override val launchType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.launchType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val loadBalancers: Optional[
      List[zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loadBalancers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails.wrap(item)
        }.toList
      )
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val networkConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails
          .wrap(value)
      )
    override val placementConstraints: Optional[List[
      zio.aws.securityhub.model.AwsEcsServicePlacementConstraintsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.placementConstraints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsServicePlacementConstraintsDetails
            .wrap(item)
        }.toList
      )
    override val placementStrategies: Optional[List[
      zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.placementStrategies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails
            .wrap(item)
        }.toList
      )
    override val platformVersion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformVersion())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val propagateTags: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.propagateTags())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val role: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.role())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val schedulingStrategy: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedulingStrategy())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val serviceArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val serviceName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val serviceRegistries: Optional[List[
      zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRegistries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails
            .wrap(item)
        }.toList
      )
    override val taskDefinition: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskDefinition())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDetails
  ): zio.aws.securityhub.model.AwsEcsServiceDetails.ReadOnly = new Wrapper(impl)
}
