package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2NetworkAclDetails(
    isDefault: Optional[Boolean] = Optional.Absent,
    networkAclId: Optional[NonEmptyString] = Optional.Absent,
    ownerId: Optional[NonEmptyString] = Optional.Absent,
    vpcId: Optional[NonEmptyString] = Optional.Absent,
    associations: Optional[
      Iterable[zio.aws.securityhub.model.AwsEc2NetworkAclAssociation]
    ] = Optional.Absent,
    entries: Optional[
      Iterable[zio.aws.securityhub.model.AwsEc2NetworkAclEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclDetails = {
    import AwsEc2NetworkAclDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclDetails
      .builder()
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .optionallyWith(
        networkAclId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkAclId)
      .optionallyWith(
        ownerId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(
        entries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entries)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEc2NetworkAclDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2NetworkAclDetails.wrap(buildAwsValue())
}
object AwsEc2NetworkAclDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2NetworkAclDetails =
      zio.aws.securityhub.model.AwsEc2NetworkAclDetails(
        isDefault.map(value => value),
        networkAclId.map(value => value),
        ownerId.map(value => value),
        vpcId.map(value => value),
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        entries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def isDefault: Optional[Boolean]
    def networkAclId: Optional[NonEmptyString]
    def ownerId: Optional[NonEmptyString]
    def vpcId: Optional[NonEmptyString]
    def associations: Optional[
      List[zio.aws.securityhub.model.AwsEc2NetworkAclAssociation.ReadOnly]
    ]
    def entries: Optional[
      List[zio.aws.securityhub.model.AwsEc2NetworkAclEntry.ReadOnly]
    ]
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
    def getNetworkAclId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkAclId", networkAclId)
    def getOwnerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2NetworkAclAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
    def getEntries: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2NetworkAclEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("entries", entries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclDetails
  ) extends zio.aws.securityhub.model.AwsEc2NetworkAclDetails.ReadOnly {
    override val isDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => value: Boolean)
    override val networkAclId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.networkAclId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ownerId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val associations: Optional[
      List[zio.aws.securityhub.model.AwsEc2NetworkAclAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2NetworkAclAssociation.wrap(item)
        }.toList
      )
    override val entries: Optional[
      List[zio.aws.securityhub.model.AwsEc2NetworkAclEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.entries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2NetworkAclEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclDetails
  ): zio.aws.securityhub.model.AwsEc2NetworkAclDetails.ReadOnly = new Wrapper(
    impl
  )
}
