package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{SizeBytes, Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableDetails(
    attributeDefinitions: Optional[
      Iterable[zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition]
    ] = Optional.Absent,
    billingModeSummary: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary
    ] = Optional.Absent,
    creationDateTime: Optional[NonEmptyString] = Optional.Absent,
    globalSecondaryIndexes: Optional[
      Iterable[zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex]
    ] = Optional.Absent,
    globalTableVersion: Optional[NonEmptyString] = Optional.Absent,
    itemCount: Optional[Integer] = Optional.Absent,
    keySchema: Optional[
      Iterable[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema]
    ] = Optional.Absent,
    latestStreamArn: Optional[NonEmptyString] = Optional.Absent,
    latestStreamLabel: Optional[NonEmptyString] = Optional.Absent,
    localSecondaryIndexes: Optional[
      Iterable[zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex]
    ] = Optional.Absent,
    provisionedThroughput: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput
    ] = Optional.Absent,
    replicas: Optional[
      Iterable[zio.aws.securityhub.model.AwsDynamoDbTableReplica]
    ] = Optional.Absent,
    restoreSummary: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary
    ] = Optional.Absent,
    sseDescription: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableSseDescription
    ] = Optional.Absent,
    streamSpecification: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification
    ] = Optional.Absent,
    tableId: Optional[NonEmptyString] = Optional.Absent,
    tableName: Optional[NonEmptyString] = Optional.Absent,
    tableSizeBytes: Optional[SizeBytes] = Optional.Absent,
    tableStatus: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableDetails = {
    import AwsDynamoDbTableDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableDetails
      .builder()
      .optionallyWith(
        attributeDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributeDefinitions)
      .optionallyWith(billingModeSummary.map(value => value.buildAwsValue()))(
        _.billingModeSummary
      )
      .optionallyWith(
        creationDateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.creationDateTime)
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexes)
      .optionallyWith(
        globalTableVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.globalTableVersion)
      .optionallyWith(itemCount.map(value => value: java.lang.Integer))(
        _.itemCount
      )
      .optionallyWith(
        keySchema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keySchema)
      .optionallyWith(
        latestStreamArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.latestStreamArn)
      .optionallyWith(
        latestStreamLabel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.latestStreamLabel)
      .optionallyWith(
        localSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localSecondaryIndexes)
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .optionallyWith(
        replicas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicas)
      .optionallyWith(restoreSummary.map(value => value.buildAwsValue()))(
        _.restoreSummary
      )
      .optionallyWith(sseDescription.map(value => value.buildAwsValue()))(
        _.sseDescription
      )
      .optionallyWith(streamSpecification.map(value => value.buildAwsValue()))(
        _.streamSpecification
      )
      .optionallyWith(
        tableId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.tableId)
      .optionallyWith(
        tableName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        tableSizeBytes.map(value => SizeBytes.unwrap(value): java.lang.Long)
      )(_.tableSizeBytes)
      .optionallyWith(
        tableStatus.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.tableStatus)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsDynamoDbTableDetails.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableDetails.wrap(buildAwsValue())
}
object AwsDynamoDbTableDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsDynamoDbTableDetails =
      zio.aws.securityhub.model.AwsDynamoDbTableDetails(
        attributeDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        billingModeSummary.map(value => value.asEditable),
        creationDateTime.map(value => value),
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        globalTableVersion.map(value => value),
        itemCount.map(value => value),
        keySchema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        latestStreamArn.map(value => value),
        latestStreamLabel.map(value => value),
        localSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        provisionedThroughput.map(value => value.asEditable),
        replicas.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        restoreSummary.map(value => value.asEditable),
        sseDescription.map(value => value.asEditable),
        streamSpecification.map(value => value.asEditable),
        tableId.map(value => value),
        tableName.map(value => value),
        tableSizeBytes.map(value => value),
        tableStatus.map(value => value)
      )
    def attributeDefinitions: Optional[List[
      zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition.ReadOnly
    ]]
    def billingModeSummary: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary.ReadOnly
    ]
    def creationDateTime: Optional[NonEmptyString]
    def globalSecondaryIndexes: Optional[List[
      zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex.ReadOnly
    ]]
    def globalTableVersion: Optional[NonEmptyString]
    def itemCount: Optional[Integer]
    def keySchema: Optional[
      List[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly]
    ]
    def latestStreamArn: Optional[NonEmptyString]
    def latestStreamLabel: Optional[NonEmptyString]
    def localSecondaryIndexes: Optional[List[
      zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex.ReadOnly
    ]]
    def provisionedThroughput: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput.ReadOnly
    ]
    def replicas: Optional[
      List[zio.aws.securityhub.model.AwsDynamoDbTableReplica.ReadOnly]
    ]
    def restoreSummary: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary.ReadOnly
    ]
    def sseDescription: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableSseDescription.ReadOnly
    ]
    def streamSpecification: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification.ReadOnly
    ]
    def tableId: Optional[NonEmptyString]
    def tableName: Optional[NonEmptyString]
    def tableSizeBytes: Optional[SizeBytes]
    def tableStatus: Optional[NonEmptyString]
    def getAttributeDefinitions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("attributeDefinitions", attributeDefinitions)
    def getBillingModeSummary: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary.ReadOnly
    ] = AwsError.unwrapOptionField("billingModeSummary", billingModeSummary)
    def getCreationDateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
    def getGlobalTableVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("globalTableVersion", globalTableVersion)
    def getItemCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getKeySchema: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly
    ]] = AwsError.unwrapOptionField("keySchema", keySchema)
    def getLatestStreamArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("latestStreamArn", latestStreamArn)
    def getLatestStreamLabel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("latestStreamLabel", latestStreamLabel)
    def getLocalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex.ReadOnly
    ]] =
      AwsError.unwrapOptionField("localSecondaryIndexes", localSecondaryIndexes)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
    def getReplicas: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDynamoDbTableReplica.ReadOnly
    ]] = AwsError.unwrapOptionField("replicas", replicas)
    def getRestoreSummary: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary.ReadOnly
    ] = AwsError.unwrapOptionField("restoreSummary", restoreSummary)
    def getSseDescription: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableSseDescription.ReadOnly
    ] = AwsError.unwrapOptionField("sseDescription", sseDescription)
    def getStreamSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("streamSpecification", streamSpecification)
    def getTableId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tableId", tableId)
    def getTableName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getTableSizeBytes: ZIO[Any, AwsError, SizeBytes] =
      AwsError.unwrapOptionField("tableSizeBytes", tableSizeBytes)
    def getTableStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tableStatus", tableStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableDetails
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableDetails.ReadOnly {
    override val attributeDefinitions: Optional[List[
      zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition
            .wrap(item)
        }.toList
      )
    override val billingModeSummary: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.billingModeSummary())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary.wrap(value)
      )
    override val creationDateTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationDateTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val globalSecondaryIndexes: Optional[List[
      zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.globalSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex
            .wrap(item)
        }.toList
      )
    override val globalTableVersion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalTableVersion())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val itemCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.itemCount())
      .map(value => value: Integer)
    override val keySchema: Optional[
      List[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.keySchema())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.wrap(item)
        }.toList
      )
    override val latestStreamArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestStreamArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val latestStreamLabel: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestStreamLabel())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val localSecondaryIndexes: Optional[List[
      zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.localSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex
            .wrap(item)
        }.toList
      )
    override val provisionedThroughput: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedThroughput())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput
          .wrap(value)
      )
    override val replicas: Optional[
      List[zio.aws.securityhub.model.AwsDynamoDbTableReplica.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicas())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDynamoDbTableReplica.wrap(item)
        }.toList
      )
    override val restoreSummary: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.restoreSummary())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary.wrap(value)
      )
    override val sseDescription: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableSseDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sseDescription())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableSseDescription.wrap(value)
      )
    override val streamSpecification: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.streamSpecification())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification
          .wrap(value)
      )
    override val tableId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.tableId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val tableName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val tableSizeBytes: Optional[SizeBytes] = zio.aws.core.internal
      .optionalFromNullable(impl.tableSizeBytes())
      .map(value => zio.aws.securityhub.model.primitives.SizeBytes(value))
    override val tableStatus: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.tableStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableDetails
  ): zio.aws.securityhub.model.AwsDynamoDbTableDetails.ReadOnly = new Wrapper(
    impl
  )
}
