package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkHeader(
    protocol: Optional[NonEmptyString] = Optional.Absent,
    destination: Optional[
      zio.aws.securityhub.model.NetworkPathComponentDetails
    ] = Optional.Absent,
    source: Optional[zio.aws.securityhub.model.NetworkPathComponentDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.NetworkHeader = {
    import NetworkHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.NetworkHeader
      .builder()
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.NetworkHeader.ReadOnly =
    zio.aws.securityhub.model.NetworkHeader.wrap(buildAwsValue())
}
object NetworkHeader {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.NetworkHeader
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.NetworkHeader =
      zio.aws.securityhub.model.NetworkHeader(
        protocol.map(value => value),
        destination.map(value => value.asEditable),
        source.map(value => value.asEditable)
      )
    def protocol: Optional[NonEmptyString]
    def destination: Optional[
      zio.aws.securityhub.model.NetworkPathComponentDetails.ReadOnly
    ]
    def source: Optional[
      zio.aws.securityhub.model.NetworkPathComponentDetails.ReadOnly
    ]
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getDestination: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.NetworkPathComponentDetails.ReadOnly
    ] = AwsError.unwrapOptionField("destination", destination)
    def getSource: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.NetworkPathComponentDetails.ReadOnly
    ] = AwsError.unwrapOptionField("source", source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.NetworkHeader
  ) extends zio.aws.securityhub.model.NetworkHeader.ReadOnly {
    override val protocol: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val destination: Optional[
      zio.aws.securityhub.model.NetworkPathComponentDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value =>
        zio.aws.securityhub.model.NetworkPathComponentDetails.wrap(value)
      )
    override val source: Optional[
      zio.aws.securityhub.model.NetworkPathComponentDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value =>
        zio.aws.securityhub.model.NetworkPathComponentDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.NetworkHeader
  ): zio.aws.securityhub.model.NetworkHeader.ReadOnly = new Wrapper(impl)
}
