package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMembersRequest(accountIds: Iterable[NonEmptyString]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetMembersRequest = {
    import GetMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetMembersRequest
      .builder()
      .accountIds(accountIds.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.GetMembersRequest.ReadOnly =
    zio.aws.securityhub.model.GetMembersRequest.wrap(buildAwsValue())
}
object GetMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetMembersRequest =
      zio.aws.securityhub.model.GetMembersRequest(accountIds)
    def accountIds: List[NonEmptyString]
    def getAccountIds: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetMembersRequest
  ) extends zio.aws.securityhub.model.GetMembersRequest.ReadOnly {
    override val accountIds: List[NonEmptyString] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetMembersRequest
  ): zio.aws.securityhub.model.GetMembersRequest.ReadOnly = new Wrapper(impl)
}
