package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FirewallPolicyStatelessCustomActionsDetails(
    actionDefinition: Optional[
      zio.aws.securityhub.model.StatelessCustomActionDefinition
    ] = Optional.Absent,
    actionName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessCustomActionsDetails = {
    import FirewallPolicyStatelessCustomActionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessCustomActionsDetails
      .builder()
      .optionallyWith(actionDefinition.map(value => value.buildAwsValue()))(
        _.actionDefinition
      )
      .optionallyWith(
        actionName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.actionName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails.ReadOnly =
    zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails
      .wrap(buildAwsValue())
}
object FirewallPolicyStatelessCustomActionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessCustomActionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails =
      zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails(
        actionDefinition.map(value => value.asEditable),
        actionName.map(value => value)
      )
    def actionDefinition: Optional[
      zio.aws.securityhub.model.StatelessCustomActionDefinition.ReadOnly
    ]
    def actionName: Optional[NonEmptyString]
    def getActionDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.StatelessCustomActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("actionDefinition", actionDefinition)
    def getActionName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("actionName", actionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessCustomActionsDetails
  ) extends zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails.ReadOnly {
    override val actionDefinition: Optional[
      zio.aws.securityhub.model.StatelessCustomActionDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.actionDefinition())
      .map(value =>
        zio.aws.securityhub.model.StatelessCustomActionDefinition.wrap(value)
      )
    override val actionName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.actionName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessCustomActionsDetails
  ): zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails.ReadOnly =
    new Wrapper(impl)
}
