package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeProductsResponse(
    products: Iterable[zio.aws.securityhub.model.Product],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse = {
    import DescribeProductsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse
      .builder()
      .products(products.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DescribeProductsResponse.ReadOnly =
    zio.aws.securityhub.model.DescribeProductsResponse.wrap(buildAwsValue())
}
object DescribeProductsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DescribeProductsResponse =
      zio.aws.securityhub.model.DescribeProductsResponse(
        products.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def products: List[zio.aws.securityhub.model.Product.ReadOnly]
    def nextToken: Optional[NextToken]
    def getProducts
        : ZIO[Any, Nothing, List[zio.aws.securityhub.model.Product.ReadOnly]] =
      ZIO.succeed(products)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse
  ) extends zio.aws.securityhub.model.DescribeProductsResponse.ReadOnly {
    override val products: List[zio.aws.securityhub.model.Product.ReadOnly] =
      impl
        .products()
        .asScala
        .map { item =>
          zio.aws.securityhub.model.Product.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse
  ): zio.aws.securityhub.model.DescribeProductsResponse.ReadOnly = new Wrapper(
    impl
  )
}
