package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsDbSecurityGroupDetails(
    dbSecurityGroupArn: Optional[NonEmptyString] = Optional.Absent,
    dbSecurityGroupDescription: Optional[NonEmptyString] = Optional.Absent,
    dbSecurityGroupName: Optional[NonEmptyString] = Optional.Absent,
    ec2SecurityGroups: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup]
    ] = Optional.Absent,
    ipRanges: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbSecurityGroupIpRange]
    ] = Optional.Absent,
    ownerId: Optional[NonEmptyString] = Optional.Absent,
    vpcId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupDetails = {
    import AwsRdsDbSecurityGroupDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupDetails
      .builder()
      .optionallyWith(
        dbSecurityGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbSecurityGroupArn)
      .optionallyWith(
        dbSecurityGroupDescription.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbSecurityGroupDescription)
      .optionallyWith(
        dbSecurityGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbSecurityGroupName)
      .optionallyWith(
        ec2SecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2SecurityGroups)
      .optionallyWith(
        ipRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipRanges)
      .optionallyWith(
        ownerId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsDbSecurityGroupDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbSecurityGroupDetails.wrap(buildAwsValue())
}
object AwsRdsDbSecurityGroupDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbSecurityGroupDetails =
      zio.aws.securityhub.model.AwsRdsDbSecurityGroupDetails(
        dbSecurityGroupArn.map(value => value),
        dbSecurityGroupDescription.map(value => value),
        dbSecurityGroupName.map(value => value),
        ec2SecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerId.map(value => value),
        vpcId.map(value => value)
      )
    def dbSecurityGroupArn: Optional[NonEmptyString]
    def dbSecurityGroupDescription: Optional[NonEmptyString]
    def dbSecurityGroupName: Optional[NonEmptyString]
    def ec2SecurityGroups: Optional[List[
      zio.aws.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup.ReadOnly
    ]]
    def ipRanges: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbSecurityGroupIpRange.ReadOnly]
    ]
    def ownerId: Optional[NonEmptyString]
    def vpcId: Optional[NonEmptyString]
    def getDbSecurityGroupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbSecurityGroupArn", dbSecurityGroupArn)
    def getDbSecurityGroupDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "dbSecurityGroupDescription",
        dbSecurityGroupDescription
      )
    def getDbSecurityGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbSecurityGroupName", dbSecurityGroupName)
    def getEc2SecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2SecurityGroups", ec2SecurityGroups)
    def getIpRanges: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbSecurityGroupIpRange.ReadOnly
    ]] = AwsError.unwrapOptionField("ipRanges", ipRanges)
    def getOwnerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupDetails
  ) extends zio.aws.securityhub.model.AwsRdsDbSecurityGroupDetails.ReadOnly {
    override val dbSecurityGroupArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSecurityGroupArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val dbSecurityGroupDescription: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSecurityGroupDescription())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val dbSecurityGroupName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSecurityGroupName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val ec2SecurityGroups: Optional[List[
      zio.aws.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2SecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup
            .wrap(item)
        }.toList
      )
    override val ipRanges: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbSecurityGroupIpRange.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbSecurityGroupIpRange.wrap(item)
        }.toList
      )
    override val ownerId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupDetails
  ): zio.aws.securityhub.model.AwsRdsDbSecurityGroupDetails.ReadOnly =
    new Wrapper(impl)
}
