package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsNetworkFirewallFirewallSubnetMappingsDetails(
    subnetId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails = {
    import AwsNetworkFirewallFirewallSubnetMappingsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails
      .builder()
      .optionallyWith(
        subnetId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails
      .wrap(buildAwsValue())
}
object AwsNetworkFirewallFirewallSubnetMappingsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails =
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails(
        subnetId.map(value => value)
      )
    def subnetId: Optional[NonEmptyString]
    def getSubnetId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetId", subnetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails
  ) extends zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails.ReadOnly {
    override val subnetId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails
  ): zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails.ReadOnly =
    new Wrapper(impl)
}
