package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElasticsearchDomainNodeToNodeEncryptionOptions(
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions = {
    import AwsElasticsearchDomainNodeToNodeEncryptionOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions.ReadOnly =
    zio.aws.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions
      .wrap(buildAwsValue())
}
object AwsElasticsearchDomainNodeToNodeEncryptionOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions =
      zio.aws.securityhub.model
        .AwsElasticsearchDomainNodeToNodeEncryptionOptions(
          enabled.map(value => value)
        )
    def enabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions
  ) extends zio.aws.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions
  ): zio.aws.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions.ReadOnly =
    new Wrapper(impl)
}
