package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2VpnConnectionVgwTelemetryDetails(
    acceptedRouteCount: Optional[Integer] = Optional.Absent,
    certificateArn: Optional[NonEmptyString] = Optional.Absent,
    lastStatusChange: Optional[NonEmptyString] = Optional.Absent,
    outsideIpAddress: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent,
    statusMessage: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails = {
    import AwsEc2VpnConnectionVgwTelemetryDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails
      .builder()
      .optionallyWith(
        acceptedRouteCount.map(value => value: java.lang.Integer)
      )(_.acceptedRouteCount)
      .optionallyWith(
        certificateArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        lastStatusChange.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastStatusChange)
      .optionallyWith(
        outsideIpAddress.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.outsideIpAddress)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails
      .wrap(buildAwsValue())
}
object AwsEc2VpnConnectionVgwTelemetryDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails =
      zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails(
        acceptedRouteCount.map(value => value),
        certificateArn.map(value => value),
        lastStatusChange.map(value => value),
        outsideIpAddress.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def acceptedRouteCount: Optional[Integer]
    def certificateArn: Optional[NonEmptyString]
    def lastStatusChange: Optional[NonEmptyString]
    def outsideIpAddress: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def statusMessage: Optional[NonEmptyString]
    def getAcceptedRouteCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("acceptedRouteCount", acceptedRouteCount)
    def getCertificateArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getLastStatusChange: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastStatusChange", lastStatusChange)
    def getOutsideIpAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("outsideIpAddress", outsideIpAddress)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails
  ) extends zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails.ReadOnly {
    override val acceptedRouteCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptedRouteCount())
      .map(value => value: Integer)
    override val certificateArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val lastStatusChange: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastStatusChange())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val outsideIpAddress: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outsideIpAddress())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val statusMessage: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails
  ): zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails.ReadOnly =
    new Wrapper(impl)
}
