package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableProvisionedThroughput(
    lastDecreaseDateTime: Optional[NonEmptyString] = Optional.Absent,
    lastIncreaseDateTime: Optional[NonEmptyString] = Optional.Absent,
    numberOfDecreasesToday: Optional[Integer] = Optional.Absent,
    readCapacityUnits: Optional[Integer] = Optional.Absent,
    writeCapacityUnits: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput = {
    import AwsDynamoDbTableProvisionedThroughput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput
      .builder()
      .optionallyWith(
        lastDecreaseDateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastDecreaseDateTime)
      .optionallyWith(
        lastIncreaseDateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastIncreaseDateTime)
      .optionallyWith(
        numberOfDecreasesToday.map(value => value: java.lang.Integer)
      )(_.numberOfDecreasesToday)
      .optionallyWith(readCapacityUnits.map(value => value: java.lang.Integer))(
        _.readCapacityUnits
      )
      .optionallyWith(
        writeCapacityUnits.map(value => value: java.lang.Integer)
      )(_.writeCapacityUnits)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput
      .wrap(buildAwsValue())
}
object AwsDynamoDbTableProvisionedThroughput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput =
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput(
        lastDecreaseDateTime.map(value => value),
        lastIncreaseDateTime.map(value => value),
        numberOfDecreasesToday.map(value => value),
        readCapacityUnits.map(value => value),
        writeCapacityUnits.map(value => value)
      )
    def lastDecreaseDateTime: Optional[NonEmptyString]
    def lastIncreaseDateTime: Optional[NonEmptyString]
    def numberOfDecreasesToday: Optional[Integer]
    def readCapacityUnits: Optional[Integer]
    def writeCapacityUnits: Optional[Integer]
    def getLastDecreaseDateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastDecreaseDateTime", lastDecreaseDateTime)
    def getLastIncreaseDateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastIncreaseDateTime", lastIncreaseDateTime)
    def getNumberOfDecreasesToday: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("numberOfDecreasesToday", numberOfDecreasesToday)
    def getReadCapacityUnits: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("readCapacityUnits", readCapacityUnits)
    def getWriteCapacityUnits: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("writeCapacityUnits", writeCapacityUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput.ReadOnly {
    override val lastDecreaseDateTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDecreaseDateTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val lastIncreaseDateTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastIncreaseDateTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val numberOfDecreasesToday: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfDecreasesToday())
        .map(value => value: Integer)
    override val readCapacityUnits: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.readCapacityUnits())
      .map(value => value: Integer)
    override val writeCapacityUnits: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.writeCapacityUnits())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput
  ): zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput.ReadOnly =
    new Wrapper(impl)
}
