package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCertificateManagerCertificateExtendedKeyUsage(
    name: Optional[NonEmptyString] = Optional.Absent,
    oId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage = {
    import AwsCertificateManagerCertificateExtendedKeyUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        oId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.oId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage.ReadOnly =
    zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage
      .wrap(buildAwsValue())
}
object AwsCertificateManagerCertificateExtendedKeyUsage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage =
      zio.aws.securityhub.model
        .AwsCertificateManagerCertificateExtendedKeyUsage(
          name.map(value => value),
          oId.map(value => value)
        )
    def name: Optional[NonEmptyString]
    def oId: Optional[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getOId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("oId", oId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage
  ) extends zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val oId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.oId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage
  ): zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage.ReadOnly =
    new Wrapper(impl)
}
