package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Adjustment(
    metric: Optional[NonEmptyString] = Optional.Absent,
    reason: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Adjustment = {
    import Adjustment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Adjustment
      .builder()
      .optionallyWith(
        metric.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.metric)
      .optionallyWith(
        reason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Adjustment.ReadOnly =
    zio.aws.securityhub.model.Adjustment.wrap(buildAwsValue())
}
object Adjustment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Adjustment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Adjustment =
      zio.aws.securityhub.model
        .Adjustment(metric.map(value => value), reason.map(value => value))
    def metric: Optional[NonEmptyString]
    def reason: Optional[NonEmptyString]
    def getMetric: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("metric", metric)
    def getReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Adjustment
  ) extends zio.aws.securityhub.model.Adjustment.ReadOnly {
    override val metric: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.metric())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val reason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Adjustment
  ): zio.aws.securityhub.model.Adjustment.ReadOnly = new Wrapper(impl)
}
