package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait VerificationState {
  def unwrap
      : software.amazon.awssdk.services.securityhub.model.VerificationState
}
object VerificationState {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.VerificationState
  ): zio.aws.securityhub.model.VerificationState = value match {
    case software.amazon.awssdk.services.securityhub.model.VerificationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.VerificationState.UNKNOWN =>
      val r = UNKNOWN
      r
    case software.amazon.awssdk.services.securityhub.model.VerificationState.TRUE_POSITIVE =>
      val r = TRUE_POSITIVE
      r
    case software.amazon.awssdk.services.securityhub.model.VerificationState.FALSE_POSITIVE =>
      val r = FALSE_POSITIVE
      r
    case software.amazon.awssdk.services.securityhub.model.VerificationState.BENIGN_POSITIVE =>
      val r = BENIGN_POSITIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.VerificationState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.VerificationState =
      software.amazon.awssdk.services.securityhub.model.VerificationState.UNKNOWN_TO_SDK_VERSION
  }
  case object UNKNOWN extends zio.aws.securityhub.model.VerificationState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.VerificationState =
      software.amazon.awssdk.services.securityhub.model.VerificationState.UNKNOWN
  }
  case object TRUE_POSITIVE
      extends zio.aws.securityhub.model.VerificationState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.VerificationState =
      software.amazon.awssdk.services.securityhub.model.VerificationState.TRUE_POSITIVE
  }
  case object FALSE_POSITIVE
      extends zio.aws.securityhub.model.VerificationState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.VerificationState =
      software.amazon.awssdk.services.securityhub.model.VerificationState.FALSE_POSITIVE
  }
  case object BENIGN_POSITIVE
      extends zio.aws.securityhub.model.VerificationState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.VerificationState =
      software.amazon.awssdk.services.securityhub.model.VerificationState.BENIGN_POSITIVE
  }
}
