package zio.aws.securityhub.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{
  Timestamp,
  NonEmptyString,
  AccountId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Member(
    accountId: Optional[AccountId] = Optional.Absent,
    email: Optional[NonEmptyString] = Optional.Absent,
    masterId: Optional[NonEmptyString] = Optional.Absent,
    administratorId: Optional[NonEmptyString] = Optional.Absent,
    memberStatus: Optional[NonEmptyString] = Optional.Absent,
    invitedAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Member = {
    import Member.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Member
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        email.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(
        masterId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.masterId)
      .optionallyWith(
        administratorId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.administratorId)
      .optionallyWith(
        memberStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.memberStatus)
      .optionallyWith(invitedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.invitedAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Member.ReadOnly =
    zio.aws.securityhub.model.Member.wrap(buildAwsValue())
}
object Member {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Member
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Member =
      zio.aws.securityhub.model.Member(
        accountId.map(value => value),
        email.map(value => value),
        masterId.map(value => value),
        administratorId.map(value => value),
        memberStatus.map(value => value),
        invitedAt.map(value => value),
        updatedAt.map(value => value)
      )
    def accountId: Optional[AccountId]
    def email: Optional[NonEmptyString]
    def masterId: Optional[NonEmptyString]
    def administratorId: Optional[NonEmptyString]
    def memberStatus: Optional[NonEmptyString]
    def invitedAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getEmail: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("email", email)
    def getMasterId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterId", masterId)
    def getAdministratorId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("administratorId", administratorId)
    def getMemberStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("memberStatus", memberStatus)
    def getInvitedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("invitedAt", invitedAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Member
  ) extends zio.aws.securityhub.model.Member.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.securityhub.model.primitives.AccountId(value))
    override val email: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.email())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val masterId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.masterId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val administratorId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.administratorId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val memberStatus: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.memberStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val invitedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.invitedAt())
      .map(value => zio.aws.securityhub.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.securityhub.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Member
  ): zio.aws.securityhub.model.Member.ReadOnly = new Wrapper(impl)
}
