package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InsightResults(
    insightArn: NonEmptyString,
    groupByAttribute: NonEmptyString,
    resultValues: Iterable[zio.aws.securityhub.model.InsightResultValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.InsightResults = {
    import InsightResults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.InsightResults
      .builder()
      .insightArn(NonEmptyString.unwrap(insightArn): java.lang.String)
      .groupByAttribute(
        NonEmptyString.unwrap(groupByAttribute): java.lang.String
      )
      .resultValues(resultValues.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.InsightResults.ReadOnly =
    zio.aws.securityhub.model.InsightResults.wrap(buildAwsValue())
}
object InsightResults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.InsightResults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.InsightResults =
      zio.aws.securityhub.model.InsightResults(
        insightArn,
        groupByAttribute,
        resultValues.map { item =>
          item.asEditable
        }
      )
    def insightArn: NonEmptyString
    def groupByAttribute: NonEmptyString
    def resultValues
        : List[zio.aws.securityhub.model.InsightResultValue.ReadOnly]
    def getInsightArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(insightArn)
    def getGroupByAttribute: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(groupByAttribute)
    def getResultValues: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.InsightResultValue.ReadOnly
    ]] = ZIO.succeed(resultValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.InsightResults
  ) extends zio.aws.securityhub.model.InsightResults.ReadOnly {
    override val insightArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.insightArn())
    override val groupByAttribute: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.groupByAttribute())
    override val resultValues
        : List[zio.aws.securityhub.model.InsightResultValue.ReadOnly] = impl
      .resultValues()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.InsightResultValue.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.InsightResults
  ): zio.aws.securityhub.model.InsightResults.ReadOnly = new Wrapper(impl)
}
