package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsSecretsManagerSecretDetails(
    rotationRules: Optional[
      zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules
    ] = Optional.Absent,
    rotationOccurredWithinFrequency: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    rotationEnabled: Optional[Boolean] = Optional.Absent,
    rotationLambdaArn: Optional[NonEmptyString] = Optional.Absent,
    deleted: Optional[Boolean] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSecretsManagerSecretDetails = {
    import AwsSecretsManagerSecretDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSecretsManagerSecretDetails
      .builder()
      .optionallyWith(rotationRules.map(value => value.buildAwsValue()))(
        _.rotationRules
      )
      .optionallyWith(
        rotationOccurredWithinFrequency.map(value => value: java.lang.Boolean)
      )(_.rotationOccurredWithinFrequency)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(rotationEnabled.map(value => value: java.lang.Boolean))(
        _.rotationEnabled
      )
      .optionallyWith(
        rotationLambdaArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.rotationLambdaArn)
      .optionallyWith(deleted.map(value => value: java.lang.Boolean))(_.deleted)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsSecretsManagerSecretDetails.ReadOnly =
    zio.aws.securityhub.model.AwsSecretsManagerSecretDetails
      .wrap(buildAwsValue())
}
object AwsSecretsManagerSecretDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSecretsManagerSecretDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsSecretsManagerSecretDetails =
      zio.aws.securityhub.model.AwsSecretsManagerSecretDetails(
        rotationRules.map(value => value.asEditable),
        rotationOccurredWithinFrequency.map(value => value),
        kmsKeyId.map(value => value),
        rotationEnabled.map(value => value),
        rotationLambdaArn.map(value => value),
        deleted.map(value => value),
        name.map(value => value),
        description.map(value => value)
      )
    def rotationRules: Optional[
      zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules.ReadOnly
    ]
    def rotationOccurredWithinFrequency: Optional[Boolean]
    def kmsKeyId: Optional[NonEmptyString]
    def rotationEnabled: Optional[Boolean]
    def rotationLambdaArn: Optional[NonEmptyString]
    def deleted: Optional[Boolean]
    def name: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def getRotationRules: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules.ReadOnly
    ] = AwsError.unwrapOptionField("rotationRules", rotationRules)
    def getRotationOccurredWithinFrequency: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "rotationOccurredWithinFrequency",
        rotationOccurredWithinFrequency
      )
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getRotationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("rotationEnabled", rotationEnabled)
    def getRotationLambdaArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("rotationLambdaArn", rotationLambdaArn)
    def getDeleted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleted", deleted)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSecretsManagerSecretDetails
  ) extends zio.aws.securityhub.model.AwsSecretsManagerSecretDetails.ReadOnly {
    override val rotationRules: Optional[
      zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rotationRules())
      .map(value =>
        zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules
          .wrap(value)
      )
    override val rotationOccurredWithinFrequency: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rotationOccurredWithinFrequency())
        .map(value => value: Boolean)
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rotationEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.rotationEnabled())
      .map(value => value: Boolean)
    override val rotationLambdaArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rotationLambdaArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val deleted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleted())
      .map(value => value: Boolean)
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSecretsManagerSecretDetails
  ): zio.aws.securityhub.model.AwsSecretsManagerSecretDetails.ReadOnly =
    new Wrapper(impl)
}
