package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsLambdaFunctionVpcConfig(
    securityGroupIds: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    subnetIds: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    vpcId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionVpcConfig = {
    import AwsLambdaFunctionVpcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionVpcConfig
      .builder()
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig.ReadOnly =
    zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig.wrap(buildAwsValue())
}
object AwsLambdaFunctionVpcConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionVpcConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig =
      zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig(
        securityGroupIds.map(value => value),
        subnetIds.map(value => value),
        vpcId.map(value => value)
      )
    def securityGroupIds: Optional[List[NonEmptyString]]
    def subnetIds: Optional[List[NonEmptyString]]
    def vpcId: Optional[NonEmptyString]
    def getSecurityGroupIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionVpcConfig
  ) extends zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig.ReadOnly {
    override val securityGroupIds: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val subnetIds: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val vpcId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionVpcConfig
  ): zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig.ReadOnly =
    new Wrapper(impl)
}
