package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2SecurityGroupIpPermission(
    ipProtocol: Optional[NonEmptyString] = Optional.Absent,
    fromPort: Optional[Integer] = Optional.Absent,
    toPort: Optional[Integer] = Optional.Absent,
    userIdGroupPairs: Optional[
      Iterable[zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair]
    ] = Optional.Absent,
    ipRanges: Optional[
      Iterable[zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange]
    ] = Optional.Absent,
    ipv6Ranges: Optional[
      Iterable[zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range]
    ] = Optional.Absent,
    prefixListIds: Optional[
      Iterable[zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpPermission = {
    import AwsEc2SecurityGroupIpPermission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpPermission
      .builder()
      .optionallyWith(
        ipProtocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ipProtocol)
      .optionallyWith(fromPort.map(value => value: java.lang.Integer))(
        _.fromPort
      )
      .optionallyWith(toPort.map(value => value: java.lang.Integer))(_.toPort)
      .optionallyWith(
        userIdGroupPairs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userIdGroupPairs)
      .optionallyWith(
        ipRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipRanges)
      .optionallyWith(
        ipv6Ranges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Ranges)
      .optionallyWith(
        prefixListIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.prefixListIds)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly =
    zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission
      .wrap(buildAwsValue())
}
object AwsEc2SecurityGroupIpPermission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpPermission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission =
      zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission(
        ipProtocol.map(value => value),
        fromPort.map(value => value),
        toPort.map(value => value),
        userIdGroupPairs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6Ranges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        prefixListIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ipProtocol: Optional[NonEmptyString]
    def fromPort: Optional[Integer]
    def toPort: Optional[Integer]
    def userIdGroupPairs: Optional[List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair.ReadOnly
    ]]
    def ipRanges: Optional[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange.ReadOnly]
    ]
    def ipv6Ranges: Optional[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range.ReadOnly]
    ]
    def prefixListIds: Optional[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId.ReadOnly]
    ]
    def getIpProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipProtocol", ipProtocol)
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getUserIdGroupPairs: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair.ReadOnly
    ]] = AwsError.unwrapOptionField("userIdGroupPairs", userIdGroupPairs)
    def getIpRanges: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange.ReadOnly
    ]] = AwsError.unwrapOptionField("ipRanges", ipRanges)
    def getIpv6Ranges: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Ranges", ipv6Ranges)
    def getPrefixListIds: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId.ReadOnly
    ]] = AwsError.unwrapOptionField("prefixListIds", prefixListIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpPermission
  ) extends zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly {
    override val ipProtocol: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ipProtocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val fromPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.fromPort())
      .map(value => value: Integer)
    override val toPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.toPort())
      .map(value => value: Integer)
    override val userIdGroupPairs: Optional[List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.userIdGroupPairs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair
            .wrap(item)
        }.toList
      )
    override val ipRanges: Optional[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange.wrap(item)
        }.toList
      )
    override val ipv6Ranges: Optional[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Ranges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range.wrap(item)
        }.toList
      )
    override val prefixListIds: Optional[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.prefixListIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpPermission
  ): zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly =
    new Wrapper(impl)
}
