package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionOriginS3OriginConfig(
    originAccessIdentity: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig = {
    import AwsCloudFrontDistributionOriginS3OriginConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig
      .builder()
      .optionallyWith(
        originAccessIdentity.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.originAccessIdentity)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionOriginS3OriginConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig =
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig(
        originAccessIdentity.map(value => value)
      )
    def originAccessIdentity: Optional[NonEmptyString]
    def getOriginAccessIdentity: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("originAccessIdentity", originAccessIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig.ReadOnly {
    override val originAccessIdentity: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originAccessIdentity())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig.ReadOnly =
    new Wrapper(impl)
}
