package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsApiCallActionDomainDetails(
    domain: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiCallActionDomainDetails = {
    import AwsApiCallActionDomainDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiCallActionDomainDetails
      .builder()
      .optionallyWith(
        domain.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domain)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsApiCallActionDomainDetails.ReadOnly =
    zio.aws.securityhub.model.AwsApiCallActionDomainDetails
      .wrap(buildAwsValue())
}
object AwsApiCallActionDomainDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiCallActionDomainDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiCallActionDomainDetails =
      zio.aws.securityhub.model
        .AwsApiCallActionDomainDetails(domain.map(value => value))
    def domain: Optional[NonEmptyString]
    def getDomain: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiCallActionDomainDetails
  ) extends zio.aws.securityhub.model.AwsApiCallActionDomainDetails.ReadOnly {
    override val domain: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiCallActionDomainDetails
  ): zio.aws.securityhub.model.AwsApiCallActionDomainDetails.ReadOnly =
    new Wrapper(impl)
}
