package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Severity(
    product: Optional[Double] = Optional.Absent,
    label: Optional[zio.aws.securityhub.model.SeverityLabel] = Optional.Absent,
    normalized: Optional[Integer] = Optional.Absent,
    original: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Severity = {
    import Severity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Severity
      .builder()
      .optionallyWith(product.map(value => value: java.lang.Double))(_.product)
      .optionallyWith(label.map(value => value.unwrap))(_.label)
      .optionallyWith(normalized.map(value => value: java.lang.Integer))(
        _.normalized
      )
      .optionallyWith(
        original.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.original)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Severity.ReadOnly =
    zio.aws.securityhub.model.Severity.wrap(buildAwsValue())
}
object Severity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Severity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Severity =
      zio.aws.securityhub.model.Severity(
        product.map(value => value),
        label.map(value => value),
        normalized.map(value => value),
        original.map(value => value)
      )
    def product: Optional[Double]
    def label: Optional[zio.aws.securityhub.model.SeverityLabel]
    def normalized: Optional[Integer]
    def original: Optional[NonEmptyString]
    def getProduct: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("product", product)
    def getLabel: ZIO[Any, AwsError, zio.aws.securityhub.model.SeverityLabel] =
      AwsError.unwrapOptionField("label", label)
    def getNormalized: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("normalized", normalized)
    def getOriginal: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("original", original)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Severity
  ) extends zio.aws.securityhub.model.Severity.ReadOnly {
    override val product: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.product())
      .map(value => value: Double)
    override val label: Optional[zio.aws.securityhub.model.SeverityLabel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.label())
        .map(value => zio.aws.securityhub.model.SeverityLabel.wrap(value))
    override val normalized: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.normalized())
      .map(value => value: Integer)
    override val original: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.original())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Severity
  ): zio.aws.securityhub.model.Severity.ReadOnly = new Wrapper(impl)
}
