package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleGroupVariablesIpSetsDetails(
    definition: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupVariablesIpSetsDetails = {
    import RuleGroupVariablesIpSetsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupVariablesIpSetsDetails
      .builder()
      .optionallyWith(
        definition.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.definition)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupVariablesIpSetsDetails.ReadOnly =
    zio.aws.securityhub.model.RuleGroupVariablesIpSetsDetails
      .wrap(buildAwsValue())
}
object RuleGroupVariablesIpSetsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupVariablesIpSetsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.RuleGroupVariablesIpSetsDetails =
      zio.aws.securityhub.model
        .RuleGroupVariablesIpSetsDetails(definition.map(value => value))
    def definition: Optional[List[NonEmptyString]]
    def getDefinition: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("definition", definition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupVariablesIpSetsDetails
  ) extends zio.aws.securityhub.model.RuleGroupVariablesIpSetsDetails.ReadOnly {
    override val definition: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.definition())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupVariablesIpSetsDetails
  ): zio.aws.securityhub.model.RuleGroupVariablesIpSetsDetails.ReadOnly =
    new Wrapper(impl)
}
