package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleGroupVariables(
    ipSets: Optional[
      zio.aws.securityhub.model.RuleGroupVariablesIpSetsDetails
    ] = Optional.Absent,
    portSets: Optional[
      zio.aws.securityhub.model.RuleGroupVariablesPortSetsDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupVariables = {
    import RuleGroupVariables.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupVariables
      .builder()
      .optionallyWith(ipSets.map(value => value.buildAwsValue()))(_.ipSets)
      .optionallyWith(portSets.map(value => value.buildAwsValue()))(_.portSets)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.RuleGroupVariables.ReadOnly =
    zio.aws.securityhub.model.RuleGroupVariables.wrap(buildAwsValue())
}
object RuleGroupVariables {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupVariables
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.RuleGroupVariables =
      zio.aws.securityhub.model.RuleGroupVariables(
        ipSets.map(value => value.asEditable),
        portSets.map(value => value.asEditable)
      )
    def ipSets: Optional[
      zio.aws.securityhub.model.RuleGroupVariablesIpSetsDetails.ReadOnly
    ]
    def portSets: Optional[
      zio.aws.securityhub.model.RuleGroupVariablesPortSetsDetails.ReadOnly
    ]
    def getIpSets: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupVariablesIpSetsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("ipSets", ipSets)
    def getPortSets: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupVariablesPortSetsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("portSets", portSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupVariables
  ) extends zio.aws.securityhub.model.RuleGroupVariables.ReadOnly {
    override val ipSets: Optional[
      zio.aws.securityhub.model.RuleGroupVariablesIpSetsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipSets())
      .map(value =>
        zio.aws.securityhub.model.RuleGroupVariablesIpSetsDetails.wrap(value)
      )
    override val portSets: Optional[
      zio.aws.securityhub.model.RuleGroupVariablesPortSetsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.portSets())
      .map(value =>
        zio.aws.securityhub.model.RuleGroupVariablesPortSetsDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupVariables
  ): zio.aws.securityhub.model.RuleGroupVariables.ReadOnly = new Wrapper(impl)
}
