package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RelatedFinding(
    productArn: NonEmptyString,
    id: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RelatedFinding = {
    import RelatedFinding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RelatedFinding
      .builder()
      .productArn(NonEmptyString.unwrap(productArn): java.lang.String)
      .id(NonEmptyString.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.RelatedFinding.ReadOnly =
    zio.aws.securityhub.model.RelatedFinding.wrap(buildAwsValue())
}
object RelatedFinding {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RelatedFinding
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.RelatedFinding =
      zio.aws.securityhub.model.RelatedFinding(productArn, id)
    def productArn: NonEmptyString
    def id: NonEmptyString
    def getProductArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(productArn)
    def getId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RelatedFinding
  ) extends zio.aws.securityhub.model.RelatedFinding.ReadOnly {
    override val productArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.productArn())
    override val id: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RelatedFinding
  ): zio.aws.securityhub.model.RelatedFinding.ReadOnly = new Wrapper(impl)
}
