package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Occurrences(
    lineRanges: Optional[Iterable[zio.aws.securityhub.model.Range]] =
      Optional.Absent,
    offsetRanges: Optional[Iterable[zio.aws.securityhub.model.Range]] =
      Optional.Absent,
    pages: Optional[Iterable[zio.aws.securityhub.model.Page]] = Optional.Absent,
    records: Optional[Iterable[zio.aws.securityhub.model.Record]] =
      Optional.Absent,
    cells: Optional[Iterable[zio.aws.securityhub.model.Cell]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Occurrences = {
    import Occurrences.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Occurrences
      .builder()
      .optionallyWith(
        lineRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lineRanges)
      .optionallyWith(
        offsetRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.offsetRanges)
      .optionallyWith(
        pages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pages)
      .optionallyWith(
        records.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.records)
      .optionallyWith(
        cells.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cells)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Occurrences.ReadOnly =
    zio.aws.securityhub.model.Occurrences.wrap(buildAwsValue())
}
object Occurrences {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Occurrences
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Occurrences =
      zio.aws.securityhub.model.Occurrences(
        lineRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        offsetRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        records.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cells.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def lineRanges: Optional[List[zio.aws.securityhub.model.Range.ReadOnly]]
    def offsetRanges: Optional[List[zio.aws.securityhub.model.Range.ReadOnly]]
    def pages: Optional[List[zio.aws.securityhub.model.Page.ReadOnly]]
    def records: Optional[List[zio.aws.securityhub.model.Record.ReadOnly]]
    def cells: Optional[List[zio.aws.securityhub.model.Cell.ReadOnly]]
    def getLineRanges
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Range.ReadOnly]] =
      AwsError.unwrapOptionField("lineRanges", lineRanges)
    def getOffsetRanges
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Range.ReadOnly]] =
      AwsError.unwrapOptionField("offsetRanges", offsetRanges)
    def getPages
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Page.ReadOnly]] =
      AwsError.unwrapOptionField("pages", pages)
    def getRecords
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Record.ReadOnly]] =
      AwsError.unwrapOptionField("records", records)
    def getCells
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Cell.ReadOnly]] =
      AwsError.unwrapOptionField("cells", cells)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Occurrences
  ) extends zio.aws.securityhub.model.Occurrences.ReadOnly {
    override val lineRanges
        : Optional[List[zio.aws.securityhub.model.Range.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Range.wrap(item)
          }.toList
        )
    override val offsetRanges
        : Optional[List[zio.aws.securityhub.model.Range.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offsetRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Range.wrap(item)
          }.toList
        )
    override val pages
        : Optional[List[zio.aws.securityhub.model.Page.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Page.wrap(item)
          }.toList
        )
    override val records
        : Optional[List[zio.aws.securityhub.model.Record.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.records())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Record.wrap(item)
          }.toList
        )
    override val cells
        : Optional[List[zio.aws.securityhub.model.Cell.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cells())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Cell.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Occurrences
  ): zio.aws.securityhub.model.Occurrences.ReadOnly = new Wrapper(impl)
}
