package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkConnectionAction(
    connectionDirection: Optional[NonEmptyString] = Optional.Absent,
    remoteIpDetails: Optional[zio.aws.securityhub.model.ActionRemoteIpDetails] =
      Optional.Absent,
    remotePortDetails: Optional[
      zio.aws.securityhub.model.ActionRemotePortDetails
    ] = Optional.Absent,
    localPortDetails: Optional[
      zio.aws.securityhub.model.ActionLocalPortDetails
    ] = Optional.Absent,
    protocol: Optional[NonEmptyString] = Optional.Absent,
    blocked: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.NetworkConnectionAction = {
    import NetworkConnectionAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.NetworkConnectionAction
      .builder()
      .optionallyWith(
        connectionDirection.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.connectionDirection)
      .optionallyWith(remoteIpDetails.map(value => value.buildAwsValue()))(
        _.remoteIpDetails
      )
      .optionallyWith(remotePortDetails.map(value => value.buildAwsValue()))(
        _.remotePortDetails
      )
      .optionallyWith(localPortDetails.map(value => value.buildAwsValue()))(
        _.localPortDetails
      )
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(blocked.map(value => value: java.lang.Boolean))(_.blocked)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.NetworkConnectionAction.ReadOnly =
    zio.aws.securityhub.model.NetworkConnectionAction.wrap(buildAwsValue())
}
object NetworkConnectionAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.NetworkConnectionAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.NetworkConnectionAction =
      zio.aws.securityhub.model.NetworkConnectionAction(
        connectionDirection.map(value => value),
        remoteIpDetails.map(value => value.asEditable),
        remotePortDetails.map(value => value.asEditable),
        localPortDetails.map(value => value.asEditable),
        protocol.map(value => value),
        blocked.map(value => value)
      )
    def connectionDirection: Optional[NonEmptyString]
    def remoteIpDetails
        : Optional[zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly]
    def remotePortDetails
        : Optional[zio.aws.securityhub.model.ActionRemotePortDetails.ReadOnly]
    def localPortDetails
        : Optional[zio.aws.securityhub.model.ActionLocalPortDetails.ReadOnly]
    def protocol: Optional[NonEmptyString]
    def blocked: Optional[Boolean]
    def getConnectionDirection: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("connectionDirection", connectionDirection)
    def getRemoteIpDetails: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly
    ] = AwsError.unwrapOptionField("remoteIpDetails", remoteIpDetails)
    def getRemotePortDetails: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ActionRemotePortDetails.ReadOnly
    ] = AwsError.unwrapOptionField("remotePortDetails", remotePortDetails)
    def getLocalPortDetails: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ActionLocalPortDetails.ReadOnly
    ] = AwsError.unwrapOptionField("localPortDetails", localPortDetails)
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getBlocked: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blocked", blocked)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.NetworkConnectionAction
  ) extends zio.aws.securityhub.model.NetworkConnectionAction.ReadOnly {
    override val connectionDirection: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionDirection())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val remoteIpDetails
        : Optional[zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteIpDetails())
        .map(value =>
          zio.aws.securityhub.model.ActionRemoteIpDetails.wrap(value)
        )
    override val remotePortDetails
        : Optional[zio.aws.securityhub.model.ActionRemotePortDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remotePortDetails())
        .map(value =>
          zio.aws.securityhub.model.ActionRemotePortDetails.wrap(value)
        )
    override val localPortDetails
        : Optional[zio.aws.securityhub.model.ActionLocalPortDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localPortDetails())
        .map(value =>
          zio.aws.securityhub.model.ActionLocalPortDetails.wrap(value)
        )
    override val protocol: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val blocked: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.blocked())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.NetworkConnectionAction
  ): zio.aws.securityhub.model.NetworkConnectionAction.ReadOnly = new Wrapper(
    impl
  )
}
