package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait MalwareState {
  def unwrap: software.amazon.awssdk.services.securityhub.model.MalwareState
}
object MalwareState {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.MalwareState
  ): zio.aws.securityhub.model.MalwareState = value match {
    case software.amazon.awssdk.services.securityhub.model.MalwareState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareState.OBSERVED =>
      val r = OBSERVED
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareState.REMOVAL_FAILED =>
      val r = REMOVAL_FAILED
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareState.REMOVED =>
      val r = REMOVED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.MalwareState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareState =
      software.amazon.awssdk.services.securityhub.model.MalwareState.UNKNOWN_TO_SDK_VERSION
  }
  case object OBSERVED extends zio.aws.securityhub.model.MalwareState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareState =
      software.amazon.awssdk.services.securityhub.model.MalwareState.OBSERVED
  }
  case object REMOVAL_FAILED extends zio.aws.securityhub.model.MalwareState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareState =
      software.amazon.awssdk.services.securityhub.model.MalwareState.REMOVAL_FAILED
  }
  case object REMOVED extends zio.aws.securityhub.model.MalwareState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareState =
      software.amazon.awssdk.services.securityhub.model.MalwareState.REMOVED
  }
}
