package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ImportFindingsError(
    id: NonEmptyString,
    errorCode: NonEmptyString,
    errorMessage: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ImportFindingsError = {
    import ImportFindingsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ImportFindingsError
      .builder()
      .id(NonEmptyString.unwrap(id): java.lang.String)
      .errorCode(NonEmptyString.unwrap(errorCode): java.lang.String)
      .errorMessage(NonEmptyString.unwrap(errorMessage): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ImportFindingsError.ReadOnly =
    zio.aws.securityhub.model.ImportFindingsError.wrap(buildAwsValue())
}
object ImportFindingsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ImportFindingsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ImportFindingsError =
      zio.aws.securityhub.model.ImportFindingsError(id, errorCode, errorMessage)
    def id: NonEmptyString
    def errorCode: NonEmptyString
    def errorMessage: NonEmptyString
    def getId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(id)
    def getErrorCode: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ImportFindingsError
  ) extends zio.aws.securityhub.model.ImportFindingsError.ReadOnly {
    override val id: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.id())
    override val errorCode: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.errorCode())
    override val errorMessage: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.errorMessage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ImportFindingsError
  ): zio.aws.securityhub.model.ImportFindingsError.ReadOnly = new Wrapper(impl)
}
