package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FirewallPolicyDetails(
    statefulRuleGroupReferences: Optional[Iterable[
      zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails
    ]] = Optional.Absent,
    statelessCustomActions: Optional[Iterable[
      zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails
    ]] = Optional.Absent,
    statelessDefaultActions: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    statelessFragmentDefaultActions: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    statelessRuleGroupReferences: Optional[Iterable[
      zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.FirewallPolicyDetails = {
    import FirewallPolicyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.FirewallPolicyDetails
      .builder()
      .optionallyWith(
        statefulRuleGroupReferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statefulRuleGroupReferences)
      .optionallyWith(
        statelessCustomActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statelessCustomActions)
      .optionallyWith(
        statelessDefaultActions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.statelessDefaultActions)
      .optionallyWith(
        statelessFragmentDefaultActions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.statelessFragmentDefaultActions)
      .optionallyWith(
        statelessRuleGroupReferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statelessRuleGroupReferences)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.FirewallPolicyDetails.ReadOnly =
    zio.aws.securityhub.model.FirewallPolicyDetails.wrap(buildAwsValue())
}
object FirewallPolicyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.FirewallPolicyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.FirewallPolicyDetails =
      zio.aws.securityhub.model.FirewallPolicyDetails(
        statefulRuleGroupReferences.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statelessCustomActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statelessDefaultActions.map(value => value),
        statelessFragmentDefaultActions.map(value => value),
        statelessRuleGroupReferences.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def statefulRuleGroupReferences: Optional[List[
      zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails.ReadOnly
    ]]
    def statelessCustomActions: Optional[List[
      zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails.ReadOnly
    ]]
    def statelessDefaultActions: Optional[List[NonEmptyString]]
    def statelessFragmentDefaultActions: Optional[List[NonEmptyString]]
    def statelessRuleGroupReferences: Optional[List[
      zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails.ReadOnly
    ]]
    def getStatefulRuleGroupReferences: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statefulRuleGroupReferences",
      statefulRuleGroupReferences
    )
    def getStatelessCustomActions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statelessCustomActions",
      statelessCustomActions
    )
    def getStatelessDefaultActions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "statelessDefaultActions",
        statelessDefaultActions
      )
    def getStatelessFragmentDefaultActions
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "statelessFragmentDefaultActions",
      statelessFragmentDefaultActions
    )
    def getStatelessRuleGroupReferences: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statelessRuleGroupReferences",
      statelessRuleGroupReferences
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.FirewallPolicyDetails
  ) extends zio.aws.securityhub.model.FirewallPolicyDetails.ReadOnly {
    override val statefulRuleGroupReferences: Optional[List[
      zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.statefulRuleGroupReferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails
            .wrap(item)
        }.toList
      )
    override val statelessCustomActions: Optional[List[
      zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.statelessCustomActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails
            .wrap(item)
        }.toList
      )
    override val statelessDefaultActions: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statelessDefaultActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val statelessFragmentDefaultActions
        : Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.statelessFragmentDefaultActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val statelessRuleGroupReferences: Optional[List[
      zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.statelessRuleGroupReferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.FirewallPolicyDetails
  ): zio.aws.securityhub.model.FirewallPolicyDetails.ReadOnly = new Wrapper(
    impl
  )
}
