package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CustomDataIdentifiersResult(
    detections: Optional[
      Iterable[zio.aws.securityhub.model.CustomDataIdentifiersDetections]
    ] = Optional.Absent,
    totalCount: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersResult = {
    import CustomDataIdentifiersResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersResult
      .builder()
      .optionallyWith(
        detections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.detections)
      .optionallyWith(totalCount.map(value => value: java.lang.Long))(
        _.totalCount
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.CustomDataIdentifiersResult.ReadOnly =
    zio.aws.securityhub.model.CustomDataIdentifiersResult.wrap(buildAwsValue())
}
object CustomDataIdentifiersResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.CustomDataIdentifiersResult =
      zio.aws.securityhub.model.CustomDataIdentifiersResult(
        detections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalCount.map(value => value)
      )
    def detections: Optional[
      List[zio.aws.securityhub.model.CustomDataIdentifiersDetections.ReadOnly]
    ]
    def totalCount: Optional[Long]
    def getDetections: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.CustomDataIdentifiersDetections.ReadOnly
    ]] = AwsError.unwrapOptionField("detections", detections)
    def getTotalCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersResult
  ) extends zio.aws.securityhub.model.CustomDataIdentifiersResult.ReadOnly {
    override val detections: Optional[
      List[zio.aws.securityhub.model.CustomDataIdentifiersDetections.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.detections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.CustomDataIdentifiersDetections.wrap(item)
        }.toList
      )
    override val totalCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersResult
  ): zio.aws.securityhub.model.CustomDataIdentifiersResult.ReadOnly =
    new Wrapper(impl)
}
