package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateInsightResponse(insightArn: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CreateInsightResponse = {
    import CreateInsightResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CreateInsightResponse
      .builder()
      .insightArn(NonEmptyString.unwrap(insightArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.CreateInsightResponse.ReadOnly =
    zio.aws.securityhub.model.CreateInsightResponse.wrap(buildAwsValue())
}
object CreateInsightResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CreateInsightResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.CreateInsightResponse =
      zio.aws.securityhub.model.CreateInsightResponse(insightArn)
    def insightArn: NonEmptyString
    def getInsightArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(insightArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CreateInsightResponse
  ) extends zio.aws.securityhub.model.CreateInsightResponse.ReadOnly {
    override val insightArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.insightArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CreateInsightResponse
  ): zio.aws.securityhub.model.CreateInsightResponse.ReadOnly = new Wrapper(
    impl
  )
}
