package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateActionTargetResponse(actionTargetArn: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CreateActionTargetResponse = {
    import CreateActionTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CreateActionTargetResponse
      .builder()
      .actionTargetArn(NonEmptyString.unwrap(actionTargetArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.CreateActionTargetResponse.ReadOnly =
    zio.aws.securityhub.model.CreateActionTargetResponse.wrap(buildAwsValue())
}
object CreateActionTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CreateActionTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.CreateActionTargetResponse =
      zio.aws.securityhub.model.CreateActionTargetResponse(actionTargetArn)
    def actionTargetArn: NonEmptyString
    def getActionTargetArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(actionTargetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CreateActionTargetResponse
  ) extends zio.aws.securityhub.model.CreateActionTargetResponse.ReadOnly {
    override val actionTargetArn: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.actionTargetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CreateActionTargetResponse
  ): zio.aws.securityhub.model.CreateActionTargetResponse.ReadOnly =
    new Wrapper(impl)
}
