package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait ComplianceStatus {
  def unwrap: software.amazon.awssdk.services.securityhub.model.ComplianceStatus
}
object ComplianceStatus {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.ComplianceStatus
  ): zio.aws.securityhub.model.ComplianceStatus = value match {
    case software.amazon.awssdk.services.securityhub.model.ComplianceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.ComplianceStatus.PASSED =>
      val r = PASSED
      r
    case software.amazon.awssdk.services.securityhub.model.ComplianceStatus.WARNING =>
      val r = WARNING
      r
    case software.amazon.awssdk.services.securityhub.model.ComplianceStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.securityhub.model.ComplianceStatus.NOT_AVAILABLE =>
      val r = NOT_AVAILABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.ComplianceStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ComplianceStatus =
      software.amazon.awssdk.services.securityhub.model.ComplianceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PASSED extends zio.aws.securityhub.model.ComplianceStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ComplianceStatus =
      software.amazon.awssdk.services.securityhub.model.ComplianceStatus.PASSED
  }
  case object WARNING extends zio.aws.securityhub.model.ComplianceStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ComplianceStatus =
      software.amazon.awssdk.services.securityhub.model.ComplianceStatus.WARNING
  }
  case object FAILED extends zio.aws.securityhub.model.ComplianceStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ComplianceStatus =
      software.amazon.awssdk.services.securityhub.model.ComplianceStatus.FAILED
  }
  case object NOT_AVAILABLE extends zio.aws.securityhub.model.ComplianceStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ComplianceStatus =
      software.amazon.awssdk.services.securityhub.model.ComplianceStatus.NOT_AVAILABLE
  }
}
