package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Compliance(
    status: Optional[zio.aws.securityhub.model.ComplianceStatus] =
      Optional.Absent,
    relatedRequirements: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    statusReasons: Optional[Iterable[zio.aws.securityhub.model.StatusReason]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Compliance = {
    import Compliance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Compliance
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        relatedRequirements.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.relatedRequirements)
      .optionallyWith(
        statusReasons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statusReasons)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Compliance.ReadOnly =
    zio.aws.securityhub.model.Compliance.wrap(buildAwsValue())
}
object Compliance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Compliance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Compliance =
      zio.aws.securityhub.model.Compliance(
        status.map(value => value),
        relatedRequirements.map(value => value),
        statusReasons.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def status: Optional[zio.aws.securityhub.model.ComplianceStatus]
    def relatedRequirements: Optional[List[NonEmptyString]]
    def statusReasons
        : Optional[List[zio.aws.securityhub.model.StatusReason.ReadOnly]]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.securityhub.model.ComplianceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRelatedRequirements: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("relatedRequirements", relatedRequirements)
    def getStatusReasons: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StatusReason.ReadOnly
    ]] = AwsError.unwrapOptionField("statusReasons", statusReasons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Compliance
  ) extends zio.aws.securityhub.model.Compliance.ReadOnly {
    override val status: Optional[zio.aws.securityhub.model.ComplianceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.securityhub.model.ComplianceStatus.wrap(value))
    override val relatedRequirements: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedRequirements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val statusReasons
        : Optional[List[zio.aws.securityhub.model.StatusReason.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReasons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StatusReason.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Compliance
  ): zio.aws.securityhub.model.Compliance.ReadOnly = new Wrapper(impl)
}
