package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketWebsiteConfigurationRedirectTo(
    hostname: Optional[NonEmptyString] = Optional.Absent,
    protocol: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo = {
    import AwsS3BucketWebsiteConfigurationRedirectTo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo
      .builder()
      .optionallyWith(
        hostname.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.hostname)
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo
      .wrap(buildAwsValue())
}
object AwsS3BucketWebsiteConfigurationRedirectTo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo =
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo(
        hostname.map(value => value),
        protocol.map(value => value)
      )
    def hostname: Optional[NonEmptyString]
    def protocol: Optional[NonEmptyString]
    def getHostname: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo
  ) extends zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo.ReadOnly {
    override val hostname: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.hostname())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val protocol: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo
  ): zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo.ReadOnly =
    new Wrapper(impl)
}
