package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsDbSubnetGroupSubnet(
    subnetIdentifier: Optional[NonEmptyString] = Optional.Absent,
    subnetAvailabilityZone: Optional[
      zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnetAvailabilityZone
    ] = Optional.Absent,
    subnetStatus: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroupSubnet = {
    import AwsRdsDbSubnetGroupSubnet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroupSubnet
      .builder()
      .optionallyWith(
        subnetIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.subnetIdentifier)
      .optionallyWith(
        subnetAvailabilityZone.map(value => value.buildAwsValue())
      )(_.subnetAvailabilityZone)
      .optionallyWith(
        subnetStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.subnetStatus)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnet.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnet.wrap(buildAwsValue())
}
object AwsRdsDbSubnetGroupSubnet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroupSubnet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnet =
      zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnet(
        subnetIdentifier.map(value => value),
        subnetAvailabilityZone.map(value => value.asEditable),
        subnetStatus.map(value => value)
      )
    def subnetIdentifier: Optional[NonEmptyString]
    def subnetAvailabilityZone: Optional[
      zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnetAvailabilityZone.ReadOnly
    ]
    def subnetStatus: Optional[NonEmptyString]
    def getSubnetIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetIdentifier", subnetIdentifier)
    def getSubnetAvailabilityZone: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnetAvailabilityZone.ReadOnly
    ] = AwsError.unwrapOptionField(
      "subnetAvailabilityZone",
      subnetAvailabilityZone
    )
    def getSubnetStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetStatus", subnetStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroupSubnet
  ) extends zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnet.ReadOnly {
    override val subnetIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val subnetAvailabilityZone: Optional[
      zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnetAvailabilityZone.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetAvailabilityZone())
      .map(value =>
        zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnetAvailabilityZone
          .wrap(value)
      )
    override val subnetStatus: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroupSubnet
  ): zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnet.ReadOnly = new Wrapper(
    impl
  )
}
